#!/bin/bash

###############################################################################
# File: runTest-local.sh
# Desc: Print on stdout commands for run on local machine
# Author: Jan Drazil
###############################################################################

function getInterpret()
{
  if [[ "$1" == *.py3.py ]]; then
    echo -n "/usr/bin/python3"
  elif [[ "$1" == *.py2.py ]]; then
    echo -n "/usr/bin/python2.7"
  elif [[ "$1" == *.php ]]; then
    echo -n "/usr/bin/php"
  elif [[ "$1" == *.lua ]]; then
    echo -n "/usr/bin/lua"
  else
    echo -n "NOT RECOGNIZED"
  fi
}

tests="$(dirname $0)/tests"      #dir with local tests
startPath=`pwd`

### Process params
while getopts 'p:l:t:r:eh' opt; do
  case "$opt" in
    h)
      echo -e "Usage: runTest-remote [-l local tests]"
      echo -e "                      [test filter] [...]"
      echo -e "Options description:"
      echo -e "\t-l local tests\tLocal directory with tests"
      echo -e "\ttest filter\tFilters of tests"
      exit 0
      ;;
    p) 
      port="$OPTARG"
      if ! [[ "$port" =~ ^[0-9]+$ ]]; then
        echo "Port must be a number!" >&2
        exit 1
      fi
      ;;
    l)
      tests="$OPTARG"
      ;;
  esac
done

### Check for local tests
if ! [ -d "$tests" ]; then
  echo "$tests doesn't exist!" >&2
  exit 1
fi

unprocParam=$(($# - ($OPTIND-1)))
fileFilter=""
for (( i=0; i < $(($# - ($OPTIND-1))); i++)); do
  eval "fileFilter=\"$fileFilter|(\$$(($OPTIND + $i)))\""
done
fileFilter="${fileFilter#|}"

cd "$tests"
echo "#!/bin/sh"
while read -d $'\0' testfile; do
  interpret=`getInterpret "${testfile}"`
  echo "echo -n \"Test ${testfile}:\""
  echo "${interpret} \"$testfile\" 1>\"${testfile}.out\" 2>\"${testfile}.err\" &"
  echo "testPid=\$!"
  echo "while kill -0 \${testPid} > /dev/null; do"
  echo -e "\t pmap \${testPid} | grep mapped >> ${testfile}.mem"
  echo -e "\t sleep 1"
  echo "done"
  echo "wait \$testPid"
  echo "echo \"DONE\""
  echo "##################################################"
done < <(find . -mindepth 1 -type f -print0 | grep -Evz "(\.out)|(\.time)|(\.log)|(\.err)\$" | grep -Ez "$fileFilter" )
