#!/bin/bash

###############################################################################
# File: runTest-local.sh
# Desc: Print on stdout commands for run on local machine
# Author: Jan Drazil
###############################################################################

function getInterpret()
{
  if [[ "$1" == *.py3.py ]]; then
    echo -n "/usr/bin/python3"
  elif [[ "$1" == *.py2.py ]]; then
    echo -n "/usr/bin/python2.7"
  elif [[ "$1" == *.php ]]; then
    echo -n "/usr/bin/php"
  elif [[ "$1" == *.lua ]]; then
    echo -n "/usr/bin/lua"
  else
    echo -n "NOT RECOGNIZED"
  fi
}

port=80                          #remote http port
tests="$(dirname $0)/tests"      #dir with local tests
startPath=`pwd`
timeout="2m"                     #timeout of remote script
repeat=1                         #count of test repeat
execution="time"                 #result is output from time

### Process params
while getopts 'p:l:t:r:eh' opt; do
  case "$opt" in
    h)
      echo -e "Usage: runTest-remote [-l local tests] [-r repeat] [-t timeout]"
      echo -e "                      [test filter] [...]"
      echo -e "Options description:"
      echo -e "\t-l local tests\tLocal directory with tests"
      echo -e "\t-r repeat\tCount of repeat tests"
      echo -e "\t-t timeout\tTimeout of tests (for format see man timeout(1))"
      echo -e "\t-e \t\tExpected output is execution time"
      echo -e "\ttest filter\tFilters of tests"
      exit 0
      ;;
    p) 
      port="$OPTARG"
      if ! [[ "$port" =~ ^[0-9]+$ ]]; then
        echo "Port must be a number!" >&2
        exit 1
      fi
      ;;
    l)
      tests="$OPTARG"
      ;;
    t)
      timeout="$OPTARG"
      ;;
    e)
      execution="err"
      ;;
    r)
      repeat="$OPTARG"
      if ! [[ "$repeat" =~ ^[0-9]+$ ]]; then
        echo "Repeat must be a number!" >&2
        exit 1
      fi
      ;;
  esac
done

### Check for local tests
if ! [ -d "$tests" ]; then
  echo "$tests doesn't exist!" >&2
  exit 1
fi

if [[ $timeout == "0" ]]; then
  timeout=""
else
  timeout="timeout \"$timeout\" "
fi

if [[ $execution == "err" ]]; then
  time=""
else
  time="/usr/bin/time -v "
fi

unprocParam=$(($# - ($OPTIND-1)))
fileFilter=""
for (( i=0; i < $(($# - ($OPTIND-1))); i++)); do
  eval "fileFilter=\"$fileFilter|(\$$(($OPTIND + $i)))\""
done
fileFilter="${fileFilter#|}"

cd "$tests"
exec 3<&0 ### Create copy of stdin
echo "#!/bin/sh"
while read -d $'\0' testfile; do
  counter=0
  while [ $counter -lt $repeat ]; do
    interpret=`getInterpret "${testfile}"`
    echo "echo -n \"Test ${testfile}:\""
    echo "${timeout}${time}${interpret} \"$testfile\" 1>\"${testfile}.${counter}.out\" 2>\"${testfile}.${counter}.${execution}\""
    echo "echo \"DONE\""
    counter=$(($counter + 1))
  done
done < <(find . -mindepth 1 -type f -print0 | grep -Evz "(\.out)|(\.time)|(\.log)|(\.err)\$" | grep -Ez "$fileFilter" )
