#!/bin/bash

###############################################################################
# File: makeTest.sh
# Desc: Combine data and test script to new tests directory
# Author: Jan Drazil
###############################################################################

#Function combine data file and test file for whole script language
# 1st param: language name
# 2nd param: extension of created tests
# 3rd param: if not null then script generate tests with execution time code
function createTests() {
  mkdir "tests/$1" #create dir with script lang name
  
  for dir in `find "$1" -maxdepth 1 -mindepth 1 -type d`; do #loop over all tests cathegory
    directory=`basename $dir`
    if [ "$directory" == "support" ] || [ "$directory" == "others" ]; then
      continue
    fi
    mkdir "tests/$1/$directory"
    for file in `find "$1/$directory" -maxdepth 1 -mindepth 1 -type f`; do #loop over all test script in current cathegory
      filename=`basename "$file"`
      for data in `find data/$directory -maxdepth 1 -mindepth 1 -type f`; do #loop over all data in same cathegory
        dataname=`basename "$data"`
        if [ "${dataname##*.}"  ==  "key" ]; then
          continue
        fi
        keyfile="${data}.key"
        
        prepareEval="python3 generators/generate${1}.py " #generator for processing script lang
        prepareEval+="-f \"tests/$1/${directory}/${filename%.*}_${dataname}.${2}\" " #dest file name combine test name and data name
        prepareEval+="-s \"$1/${directory}/${filename}\" " #path to script with test function
        
        # special bypass for crypthography where are different data file format for every test script 
        # compare suffix of data filename (separator: _ ) with test filename
        if [ "$directory" == "cryptography" ]; then
          if [ "${filename%.*}" ==  "${dataname##*_}" ]; then
            prepareEval+="-d \"data/${directory}/${dataname}\" "
          else
            continue
          fi
        else
          prepareEval+="-d \"data/${directory}/${dataname}\" "
        fi
        
        if [ -n "$3" ]; then
         prepareEval+="-t " #if set param 3 generate execution code is turned on
        fi
        
        if [ -f "$keyfile" ]; then
            prepareEval+="--find $(< ${keyfile})" #add value from key file if exists
        fi
        eval "$prepareEval" #run generator
      done
    done
  done
}

cd `dirname $0`
root=`pwd`
if [ -d tests ]; then
  answer=""
  while [ "$answer" != "y" ] && [  "$answer" != "n" ]; do
    read -p "Directory tests exists! Delete and continue? [y/n]: " answer
  done
  if [ "$answer" == "n" ]; then
    exit 0
  fi
  rm -fr tests
fi
mkdir tests
if [ $# -eq 0 ]; then
  createTests Python3 py3.py
  createTests Python2 py2.py
  createTests PHP php
  createTests Lua lua
else
  createTests Python3 py3.py "timeOn"
  createTests Python2 py2.py "timeOn"
  createTests PHP php "timeOn"
  createTests Lua lua "timeOn"
fi

