#!/usr/bin/python3
"""
  File: killPID.py
  Desc: Simple TCP server which killing timeout tests
  Author: Jan Drazil
"""

import socketserver, socket, sys, os, io
from subprocess import call

def extToLang(file):
  if(file.endswith(".py2.py")):
    return "/usr/bin/python2"
  elif(file.endswith(".py3.py")):
    return "/usr/bin/python3"
  elif(file.endswith(".php")):
    return "/usr/bin/php-cgi"
  else:
    return None

class ConnectionHandler(socketserver.BaseRequestHandler):
  def handle(self):
    data=self.request.recv(1024).strip().lower().decode('utf-8')
    lang=extToLang(data)
    if lang is None:
      sys.stderr.write("{} try kill: {}\n".format(self.client_address[0], data))
      self.request.sendall(b'ERROR')
      return None;
    
    retCode=call(["pkill", "-n", lang])
    if retCode:
      sys.stderr.write("pkill return code: {}\n".format(retCode))
      self.request.sendall(b'FAILED')
    else:
      self.request.sendall(b'SUCCES')
  
if __name__ == "__main__":
    HOST, PORT = "10.10.10.60", 9999
    server = socketserver.TCPServer((HOST, PORT), ConnectionHandler)
    server.serve_forever()