"""
  File: generateTree.py
  Desc: Generate tree file
  Author: Jan Drazil
  
  Tree format:
    Line format: children_count;value\n
    Example:
    2;1  --- root with 2 nodes and value 1
    2;2  --- level 2 with 2 nodes, value 2, parrent root
    0;3  --- level 3, no nodes, value 3, parrent first child of root
    0;4  --- level 3, no nodes, value 4, parrent first child of root
    0;5  --- level 3, no nodes, value 5, parrent second child of root
"""

import random
import sys
from optparse import OptionParser

values = []

def makeChildren(file, depth, maxDepth, minChild, maxChild, maxValue=1000):
  if(depth < maxDepth):
    if(minChild == maxChild):
      children = maxChild
    else:
      children=random.randrange(minChild, maxChild)
  else:
    children=0;
  values.append(random.randrange(maxValue+1))
  file.write(str(children) + ";" + str(values[-1]) + "\n")
  for i in range(children):
    makeChildren(file, depth+1, maxDepth, minChild, maxChild, maxValue)

parser = OptionParser()
parser.add_option("-f", "--file", type="string", dest="filename", help="Name of generated file.")
parser.add_option("-d", "--depth", type="int", dest="depth", help="Depth of tree.")
parser.add_option("--minchild", type="int", dest="minChild", help="Minimum children of nodes.")
parser.add_option("--maxchild", type="int", dest="maxChild", help="Maximum children of nodes.")
parser.add_option("--maxvalue", type="int", dest="maxValue", help="Maximum value of nodes.", default=1000)
parser.add_option("-s", "--search", type="string", dest="search", help="Name of file with search value. Default generate filename with extension .key")
parser.add_option("-l", "--last", action="store_true", dest="last", help="Key file will not contain random number from tree but last number of tree. Cannot be used with param --false")
parser.add_option("--false", action="store_true", dest="falseResult", help="Key file will contain number that isn't in tree")

(opt, args) = parser.parse_args()

if(opt.filename is None or opt.depth is None or opt.minChild is None or opt.maxChild is None):
  sys.stderr.write("Options f, d, minchild and maxchild are required.\n");
  exit(1);
    

try:
  f = open(opt.filename, 'w')
except IOError:
  print("Cannot open file " + filename + " for writing.")
  exit(1)

try:
  if(opt.search):
    searchFile = open(opt.search, 'w')
  else:
    searchFile = open(opt.filename + ".key", 'w')
except IOError:
  print("Cannot open file " + filename + " for writing.")
  f.close()
  exit(1)

with f:
  makeChildren(f, 1, opt.depth, opt.minChild, opt.maxChild, opt.maxValue)

with searchFile:
  if(opt.falseResult):
    searchFile.write(str(opt.maxValue+1))
  elif(opt.last):
    searchFile.write(str(values[-1]))
  else:
    searchFile.write(str(values[random.randrange(len(values))]))
  
exit(0);