"""
  File: generatePrimeNumber.py
  Desc: Generate prime number
  Author: Jan Drazil
"""

import random
import sys
from optparse import OptionParser

parser = OptionParser()
parser.add_option("-f", "--file", type="string", dest="filename", help="Name of generated file.")
parser.add_option("-s", "--string", type="string", dest="string", help="Generate key to this string")
parser.add_option("-m", "--max", type="int", dest="max", help="Maximal value of prime number. (30 to 1000)", default=1000)
(opt, args) = parser.parse_args()

if(opt.filename is None):
  sys.stderr.write("Option -f is required.\n");
  exit(1);
  
if(opt.string is None):
  opt.string = ""
  for line in sys.stdin:
    opt.string += line.rstrip()

if(opt.max < 30 or opt.max > 1000):
  sys.stderr.write("Option -m must be between 30 and 1000.\n");
  exit(1);
  
primes=[2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,
        97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,
        181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,
        277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,
        383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,
        487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,
        601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,
        709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,
        827,829,839,853,857,859,863,877,881,883,887,907,911,919,929,937,941,
        947,953,967,971,977,983,991,997]

if(opt.max == 1000):
  maxIndex=len(primes)-1
else:
  maxIndex=0;
  for i in range(1,len(primes)):
    if(primes[i]>opt.max):
      break;
    if(primes[i]>primes[maxIndex]):
      maxIndex=i;

try:
  f = open(opt.filename, 'w')
except IOError:
  print("Cannot open file " + filename + " for writing.")
  
with f:
   prime1=primes[(random.randrange(1, maxIndex+1))]
   prime2=prime1
   while(abs(prime1 - prime2) < 10):
    prime2=primes[(random.randrange(1, maxIndex+1))]
   f.write(str(prime1) + '\n' +  str(prime2) +'\n'+ opt.string + '\n')
 
exit(0);