"""
  File: generatePython2.py
  Desc: Create Python2 script combine data and function
  Author: Jan Drazil
"""
import sys, io, os
from optparse import OptionParser

scriptPath=os.path.dirname(os.path.realpath(sys.argv[0]))
sys.path.append(os.path.realpath(scriptPath + "/../Python2/support"))
sys.path.append(os.path.realpath(scriptPath + "/../Python2/tree/"))
from readItems import readItems
from printItems import printItems
from arrayToTree import arrayToTree

def createDataStructure(name, data):
  structure = io.StringIO();
  print(data, end="", file=structure)
  result = name + " = " + structure.getvalue(); 
  structure.close()
  return result  

parser = OptionParser()
parser.add_option("-f", "--file", type="string", dest="filename", help="Name of generated file.")
parser.add_option("-s", "--script", type="string", dest="script", help="Script file")
parser.add_option("-d", "--data", type="string", dest="data", help="Data file")
parser.add_option("--find", type="string", dest="find", help="Data to find")
parser.add_option("-t", "--time", action="store_true", dest="time", help="Add to script execution time", default=False)
(opt, args) = parser.parse_args()

if(opt.filename is None or opt.script is None or opt.data is None):
  sys.stderr.write("Options -f, -s and -d are required.\n");
  sys.exit(1);

### Open files, copy script to destination and prepare data
try:
  scriptFile=open(opt.script, "r")
  destFile=open(opt.filename, "w")
  if opt.time:
    destFile.write("import time\n")
    destFile.write("import sys\n")
    destFile.write("executionTime=time.time()\n")
  #destFile = io.StringIO();
  destFile.write(scriptFile.read())
  destFile.write("\n\n\n###Generated###\n")
  scriptFile.close()
  data=readItems(opt.data)
except IOError:
  sys.stderr.write("Cannot open one of given files"); 
  
type = os.path.split(os.path.split(os.path.realpath(opt.script))[0])[1] #get last dir name in path to script
scriptName = os.path.splitext(os.path.split(os.path.realpath(opt.script))[1])[0]
exitCode=0

#Specilization
if scriptName == "RSA":
  #data[0] => fist prime
  #data[1] => second prime
  #data[2] => string
  destFile.write("keys=RSAcreateKey("+ str(data[0]) +", "+ str(data[1]) +")\n")
  destFile.write("print(RSAdecode(keys['publicKey'], RSAencode(keys['privateKey'], \""+ data[2] +"\")))")
 
elif scriptName == "manyVarialbes":
  destFile.write("manyVariables()\n")
  
elif scriptName == "arrayToTree":
  try:
    printItemsFile=open(scriptPath + "/../Python2/support/printTree.py", "r") 
    destFile.write(printItemsFile.read()) #add function to print tree
    destFile.write("\n\n\n" + createDataStructure("data", data) + "\n") #insert foramted data
    destFile.write("printTree(" + scriptName + "(data))") #run test and print result
  except IOError:
    exitCode=1
    sys.stderr.write(scriptPath + "../Python2/support/printTree.py: ")
    sys.stderr.write("printTree.py can't open!\n");
    
#Generalization
elif type == "sort":
  try:
    printItemsFile=open(scriptPath + "/../Python2/support/printItems.py", "r") 
    destFile.write(printItemsFile.read()) #add function to print items
    destFile.write("\n\n\n" + createDataStructure("data", data) + "\n") #insert foramted data
    destFile.write("printItems(" + scriptName + "(data))") #run test and print result
  except IOError:
    exitCode=1
    sys.stderr.write(scriptPath + "../Python2/support/printItems.py: ")
    sys.stderr.write("printItems.py can't open!\n");
    
elif type == "tree":
  try:
    destFile.write(createDataStructure("data", arrayToTree(data)) + "\n") #insert foramted data
    destFile.write("print(" + scriptName + "("+ opt.find +", data))") #run test and print result
  except TypeError:
    exitCode=1
    sys.stderr.write("Find value isn't integer");
    
elif type == "cryptography":
  #data[0] => string
  #data[1] => key
  if(str(data[1]).isdigit()): #check if key is string or integer
    key=str(data[1])
  else:
    key="\""+ str(data[1]) + "\""
  destFile.write("print("+ scriptName +"Decode("+ key +", "+ scriptName +"Encode("+ key +", \""+ data[0] +"\")))") #run test and print result

elif type == "search":
  search = data.pop()
  data.sort()
  destFile.write("\n\n\n" + createDataStructure("data", data) + "\n") #insert foramted data  
  destFile.write("print(" + scriptName + "("+ str(search) +", data))") #run test and print result
  
else:
  exitCode=1
  sys.stderr.write("Unknown script");
  
#print(destFile.getvalue())
if opt.time:
    destFile.write("\n\nexecutionTime=time.time()-executionTime\n")
    destFile.write("sys.stderr.write(\"{:.4f}\".format(executionTime))\n")
destFile.close()
sys.exit(exitCode)
  


  