"""
  File: generateItems.py
  Desc: Generate items file
  Author: Jan Drazil
  
  Item format:
    Line format:number\n
    Example:
    1 --- first item with value 1
    6 --- second item with value 6
    3 --- third item with value 3
"""

import random
import sys
from optparse import OptionParser

parser = OptionParser()
parser.add_option("-f", "--file", type="string", dest="filename", help="Name of generated file")
parser.add_option("-i", "--items", type="int", dest="items", help="Number of generated items")
parser.add_option("-s", "--search", action="store_true", dest="search", default=False, help="On last position of file generate value for searching")
parser.add_option("--maxvalue", type="int", dest="maxValue", help="Maximum value of nodes.", default=1000)
(options, args) = parser.parse_args()
filename,items,search,maxValue=options.filename,options.items,options.search,options.maxValue

if(filename is None or items is None):
  sys.stderr.write("Options -f and -i are required.\n");
  exit(1);

try:
  f = open(filename, 'w');
except IOError:
  sys.stderr.write("Cannot open file " + filename + " for writing.")
values=[]
with f:  
  for i in range (int(items)):
    values.append(random.randrange(maxValue+1))
    f.write(str(values[-1]) + "\n");
  if search:
    f.write(str(values[random.randrange(len(values))]) + "\n")
  
    
exit(0);