"""
  File: readItems.py
  Desc: Read items file
  Author: Jan Drazil
"""

def readItems(filename):
  """
    Read items from file filename
    Can raise IOError when filename cannot be opened
  """
  result=[];
  with open(filename, "r") as f:
    for line in f:
      try:
        result.append(int(line.strip()));
      except ValueError:
        result.append(line.strip());
  return result;