"""
  File: arrayToTree.py
  Desc: Convert list to tree
  Author: Jan Drazil
"""

def arrayToTree(data):
  """
    Create structure:
      root={'value':value, 'tree':[child_1, child_2, ... ,child_n]} for n>=0
      child_n = {'value':value, 'tree':[child_1, child_2, ... ,child_n]} for n>=0
  """
  result = createTree(data, 0)
  return result['tree']
  
def createTree(data, actualIndex):
  args=data[actualIndex].split(';')
  try:
    value=int(args[1].strip());
  except ValueError:
    value=args[1].strip()
  
  if(args[0] == 0):
    return {'tree': {'value': value, 'tree': list()}, 'lastIndex': actualIndex}
  else:
    tree = {'value': value, 'tree': list()}
    for i in range(int(args[0])):
      newTree=createTree(data,actualIndex+1)
      tree['tree'].append(newTree['tree'])
      actualIndex=newTree['lastIndex']
    return {'tree': tree, 'lastIndex': actualIndex}