"""
  File: heapSort.php
  Desc: Sort list contains numbers
  Author: Jan Drazil
"""

def heapSort(data):
  size=len(data)
  for i in reversed(range(int(size/2))):
    data=makeHeap(data, size - 1, i);
  for i in reversed(range(size)):
    tmp=data[0]
    data[0]=data[i]
    data[i]=tmp
    data=makeHeap(data, i - 1, 0);
  return data
  
def makeHeap(data, bottom, topIndex):
  tmp = data[topIndex];
  succ = topIndex*2 + 1;
  if (succ < bottom and data[succ] < data[succ+1]): 
    succ+=1
    
  while (succ <= bottom and tmp < data[succ]):
    data[topIndex] = data[succ]
    topIndex = succ;
    succ = succ*2 + 1;
    if (succ < bottom and data[succ] < data[succ+1]):
      succ+=1
  data[topIndex] = tmp; 
  return data