<?php
/**
  File: printTree.php
  Desc: Print tree
  Author: Jan Drazil
*/

function printTree($tree, $spaces=0, $pipePos=array())
{
  $size=count($tree['tree']);
  if($size == 0)
  {
    echo "---" . $tree['value'] . "\n";
  }
  else
  {
    echo "---" . $tree['value'];
    $spaces = $spaces + 3 + strlen($tree['value']);
    $pipePos[]=$spaces;
    for($i=0;$i<$size;$i++)
    {
      for($j=0;$j<$spaces && $i!=0 ;$j++)
      if(in_array($j,$pipePos))
        echo "|";
      else
        echo " ";
        
      if($i==$size-1)
        array_pop($pipePos);
      printTree($tree['tree'][$i], $spaces, $pipePos);
    }
  }
}
?>