<?php
/**
  File: recursQuickSort.php
  Desc: Sort array contains numbers
  Author: Jan Drazil
*/

function recursQuickSort($data)
{
  return recursQuickSortAlg($data, 0, count($data)-1);
}
  
function recursQuickSortAlg($data, $left, $right)
{
  if($left<$right)
  {
    $q=qsPartition($data, $left, $right);
    $data=recursQuickSortAlg($q['data'], $left, $q['cut']-1);
    $data=recursQuickSortAlg($data, $q['cut']+1, $right);
  }
  return $data;
}
  
function qsPartition($data, $left, $right)
{
  $pivot = $data[$right];
  $i=$left-1;
  for ($j=$left;$j<$right;$j++)
  {
    if($data[$j] <= $pivot)
    {
      $i++;
      $tmp=$data[$i];
      $data[$i]=$data[$j];
      $data[$j]=$tmp;
    }
  }
  $tmp=$data[$i+1];
  $data[$i+1]=$data[$right];
  $data[$right]=$tmp;
  return array('data'=>$data, 'cut'=>$i+1);
}
?>