<?php
/**
  File: RSA.py
  Desc: RSA encoding/decoding algorithm
  Author: Jan Drazil
*/

//Euclidean Algorithm for greatest common divisor
function gcd($a, $b)
{
  while($b!=0)
  {
    $tmp = $a % $b;
    $a = $b;
    $b = $tmp;
  }
  return $a;
}

//Extended Euclidean Algorithm
function EEA($a,$b)
{
  if($a<$b)
  {
    $tmp=$a;
    $a=$b;
    $b=$tmp;
  }
    
  $alfa1 = 0;
  $alfa2 = 1;
  $beta1 = 1;
  $beta2 = 0;
  $q=0;
  $r=0;
  while($b>0)
  {
    $q=floor($a/$b);
    $r=$a-$q*$b;
    $a=$b;
    $b=$r;
    $tmp=$alfa2;
    $alfa2=$alfa1;
    $alfa1=$tmp-$q*$alfa1;
    $tmp=$beta2;
    $beta2=$beta1;
    $beta1=$tmp-$q*$beta1;
  }
  return array($a, $alfa2, $beta2);
}    
  
  
 
//Create public and private key 
function RSAcreateKey($prime1, $prime2)
{
  $n=$prime1*$prime2;
  $eulerTotient=($prime1-1)*($prime2-1);
  for ($i=$eulerTotient-2; $i>=2; $i--) //teoreticky chyba pri prevodu ???
  {
    if(gcd($i, $eulerTotient) == 1)
    {
      $exponent=$i;
      break;
    }
  }
  $d=EEA($exponent,$eulerTotient);
  $d=$d[2]; //multiplicative inverse
  if($d<0)
    $d+=$eulerTotient; //fix negative value in Z_eulerTotient
  return array('privateKey'=> array('exponent'=> $exponent, 'modulus'=> $n), 'publicKey' => array('exponent'=> $d, 'modulus'=> $n));
}
  

function RSAencode($publicKey, $string)
{
  $letters = str_split($string);
  $size=count($letters);
  for($i=0 ; $i<$size ; $i++)
    $letters[$i]=RSAUseKey($publicKey, ord($letters[$i]));
  return $letters;
} 

function RSAdecode($privateKey, $intList)
{
  $size=count($intList);
  for($i=0 ; $i<$size ; $i++)
    $intList[$i]=chr(RSAUseKey($privateKey, $intList[$i]));
  return implode("",$intList);
} 

//Apply key to number
function RSAUseKey($key, $number)
{
  $modulus = $key['modulus'];
  $exponent = $key['exponent'];
  // (a * b) mod c = ((a mod c)(b mod c)) mod c
  // x^y mod z = (x*x*x*x*...*x) mod z
  $parcMod = $number % $modulus;
  $result = $parcMod;
  
  for($i=0;$i<$exponent-1;$i++)
    $result = ($result * $parcMod) % $modulus;
  return $result;
}

#Example of use
#$keys=RSAcreateKey(907, 997);
#$cypher=RSAencode($keys['publicKey'],"Hello World!");
#print($cypher)
#print(RSAdecode($keys['privateKey'],$cypher));
?>