--[[
  File: arrayToTree.lua
  Desc: Convert list to tree
  Author: Jan Drazil
]]

function string:split(sep)
  -- Lua don't have built-in split function
  -- Source: http://lua-users.org/wiki/SplitJoin
  local sep, fields = sep, {}
  local pattern = string.format("([^%s]+)", sep)
  self:gsub(pattern, function(c) fields[#fields+1] = c end)
  return fields
end

function arrayToTree(data)
  --[[
    Create structure:
      root={'value':value, 'tree':[child_1, child_2, ... ,child_n]} for n>=0
      child_n = {'value':value, 'tree':[child_1, child_2, ... ,child_n]} for n>=0
  ]]
  result = createTree(data, 1)
  return result['tree']
end

function createTree(data, actualIndex)
  args=data[actualIndex]:split(';')
  value=tonumber(args[2]:match'^%s*(.*%S)')
  if(not value) then
    value=args[2]:match'^%s*(.*%S)'
  end
  local tree

  if(args[1] == 0) then
    return {['tree']={['value']=value, ['tree']={}}, ['lastIndex']=actualIndex}
  else
    tree = {['value']=value, ['tree']={}}
    for i=1,args[1] do
      newTree=createTree(data,actualIndex+1)
      table.insert(tree['tree'],newTree['tree'])
      actualIndex=newTree['lastIndex']
    end
    return {['tree']=tree, ['lastIndex']=actualIndex}
  end
end
