--[[
  File: binaryRecursiveSearch.php
  Desc: Return index of item by given value
  Author: Jan Drazil
]]

function binaryRecursiveSearch(value,data)
  return binaryRecursiveSupport(value,data,1,#data)
end

function binaryRecursiveSupport(value,data,left,right)
  if(left == right and data[left] ~= value) then
    return -1
  end
  middle=math.floor((left+right)/2)
  if(data[middle]==value) then
    return middle
  elseif(data[middle] < value) then
    return binaryRecursiveSupport(value,data,middle+1,right)
  else
    return binaryRecursiveSupport(value,data,left,middle-1)
  end
end
