--[[
  File: vernam.py
  Desc: Vernams's cypher
  Author: Jan Drazil
]]

function string:split(sep)
  -- Lua don't have built-in split function
  -- Source: http://lua-users.org/wiki/SplitJoin
  local sep, fields = sep, {}
  local pattern = string.format("([^%s]+)", sep)
  self:gsub(pattern, function(c) fields[#fields+1] = c end)
  return fields
end

support = require("support")

function vernamEncode(key, str)
  letters={}
  for i=1,str:len() do
    table.insert(letters, string.byte(str, i))
  end
  keys=key:split(';')
  for i=1,#letters do
    letters[i]=support.bxor(tonumber(letters[i]), tonumber(keys[i]))
  end
  return table.concat(letters, ';')
end

function vernamDecode(key, cypher)
  letters=cypher:split(';')
  keys=key:split(';')
  for i=1,#letters do
    letters[i]=string.char(support.bxor(tonumber(letters[i]), tonumber(keys[i])))
  end
  return table.concat(letters, '')
end

--Example of use
--[[str="Hello World!";
key   ="97;74;81;81;238;210;156;221;16;227;168;133;212;";
cypher=vernamEncode(key, str)
decoded=vernamDecode(key, cypher)
print(cypher)
print(decoded)
]]
