#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <stdint.h>
#include "axi_dma.h"

char buffer[100000*1024] __attribute__((aligned(4)));
struct iovec iov[1000];

int main(int argc, char **argv)
{
    int f = open(argv[1], O_WRONLY);
    int i, j;
	uint32_t *ptr;
	int ret;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    ptr = (uint32_t *)buffer;
    for (i = 0; i < 100000*1024/4; i++)
	{
		*ptr = i;
		ptr++;
	}

    ioctl(f, START_TX_DMA, 0);
    for(i = 0; i < 100; i++)
	{
		for (j = 0; j < 1000; j++)
		{
			iov[j].iov_base = buffer + (i*1000 + j) * 1024;
		    iov[j].iov_len = 1024;
		}
        ret = writev(f, iov, 1000);
		if (ret != 1000*1024)
		{
			fprintf(stderr, "Error while writing %d ret is %d\n", i, ret);
		}
		fprintf(stderr, "Write TX buffer %d\n", i);
	}

    close(f);
}
