#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <sys/mman.h>
#include <stdint.h>
#include "axi_dma.h"

char buffer[1000*1024];
struct iovec iov[1000];

int main(int argc, char **argv)
{
	fprintf(stderr, "UMMAP 0\n");
    int f = open(argv[1], O_RDWR);
    int i, j;
	struct dma_ring *desc;
	char *ring;
	struct mmaped_dma tx;
	struct dma_settings settings;
	
	fprintf(stderr, "UMMAP 1\n");
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    fprintf(stderr, "UMMAP 2\n");
    desc = mmap(NULL, POINTER_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, f, MMAP_TX_DESC_UOFFSET);
	if (!desc)
	{
		fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_TX_DESC_UOFFSET);
        return 1;
	}
	fprintf(stderr, "UMMAP 3\n");
	ring = mmap(NULL, MAX_RING, PROT_READ | PROT_WRITE, MAP_SHARED, f, MMAP_TX_RING_UOFFSET);
	if (!ring)
	{
		munmap(desc, POINTER_SIZE);
		fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_TX_RING_UOFFSET);
        return 1;
	}

    fprintf(stderr, "UMMAP 4\n");
    ioctl(f, GET_SETTINGS, settings);
	fprintf(stderr, "UMMAP 5\n");
    ioctl(f, START_TX_DMA, 0);
    fprintf(stderr, "UMMAP 6\n");
    for (i = 0; i < 1000; i++)
	{
		 tx.len = 1000;
		 fprintf(stderr, "UMMAP 7.1\n");
		 ioctl(f, TX_MMAP_ALLOC, &tx);
		 fprintf(stderr, "UMMAP 7.2\n");
		 for (j = tx.start; j < tx.start + tx.len; j++)
		 {
			 fprintf(stderr, "UMMAP 7.3.1\n");
		     desc[j % settings.tx_desc_len].control = 1000;
			 fprintf(stderr, "UMMAP 7.3.2\n");
		     desc[j % settings.tx_desc_len].control |= DESC_SOF_EOF;
			 fprintf(stderr, "UMMAP 7.3.3\n");
		 }
		 fprintf(stderr, "UMMAP 7.4\n");
		 ioctl(f, TX_MMAP_PUT, &tx);
		 fprintf(stderr, "UMMAP 7.5\n");
	}
	fprintf(stderr, "UMMAP 8\n");
	munmap(ring, MAX_RING);
	fprintf(stderr, "UMMAP 9\n");
	munmap(desc, POINTER_SIZE);
	fprintf(stderr, "UMMAP 10\n");
    close(f);
}
