#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <sys/mman.h>
#include <stdint.h>
#include "axi_dma.h"
#include "libaio.h"

char* buffer[1000];
struct iovec iov[1000];
struct iocb viocb;
struct io_event event;

int main(int argc, char **argv)
{
    int f = open(argv[1], O_RDWR);
    int i;
	int len;
	int ret;
	struct iocb *pviocb;
	struct dma_settings settings;
    
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }


    io_context_t ctx;
    memset(&ctx, 0, sizeof(ctx));
    ret = io_queue_init(1, &ctx);
	if (ret < 0)
	{
		fprintf(stderr, "Failed to init io queue\n");
        return 1;
	}
	
    for (i = 0; i < 1000; i++)
	{
		buffer[i] = mmap(NULL, 1024, PROT_WRITE, MAP_SHARED, f, MMAP_ALLOC_UOFFSET);
		if (!buffer[i])
		{
			fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_ALLOC_UOFFSET);
            return 1;
		}
		iov[i].iov_base = buffer[i];
		iov[i].iov_len = 1024;
	}

    ioctl(f, GET_SETTINGS, &settings);
    settings.tx_mode = TX_DIRECT;
    ioctl(f, SET_SETTINGS, &settings);
    ioctl(f, START_TX_DMA, 0);

    for(i = 0; i < 1000; i++)
	{
        io_prep_pwritev(&viocb, f, iov, 1000, 0);
		pviocb = &viocb;
		if (io_submit(ctx, 1, &pviocb) < 0)
		{
			fprintf(stderr, "AIO writev failed\n");
		}
		fprintf(stderr, "TX AIO loop %d\n", i);
		ret = io_getevents(ctx, 1, 1, &event, NULL);
		if (ret < 1)
		{
			fprintf(stderr, "AIO get event failed\n");
		}
	}
	io_queue_release(ctx);
    close(f);
}
