#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <stdint.h>
#include "axi_dma.h"

char buffer[1000*1024];
struct iovec iov[1000];

int main(int argc, char **argv)
{
    int f = open(argv[1], O_RDONLY);
    int i;
    int len;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    for (i = 0; i < 1000; i++)
	{
		iov[i].iov_base = buffer + i * 1024;
		iov[i].iov_len = 1024;
	}

    ioctl(f, START_RX_DMA, 0);

    while (i < 1000000)
    {
        len = readv(f, iov, 1000);
        i+= len / 1024;
    }
    close(f);
}