#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <stdint.h>
#include <sys/mman.h>
#include <limits.h>
#include "axi_dma.h"

char buffer[1000*1024];
struct iovec iov[1000];

int main(int argc, char **argv)
{
    int f = open(argv[1], O_RDONLY);
    int i, j;
	struct dma_ring *desc;
	struct dma_ring *desc_el;
	char *ring;
	struct mmaped_dma rx;
	struct dma_settings settings;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    desc = mmap(NULL, POINTER_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, f, MMAP_RX_DESC_UOFFSET);
	if (!desc)
	{
		fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_RX_DESC_UOFFSET);
        return 1;
	}
	ring = mmap(NULL, MAX_RING, PROT_READ | PROT_WRITE, MAP_SHARED, f, MMAP_RX_RING_UOFFSET);
	if (!ring)
	{
		munmap(desc, POINTER_SIZE);
		fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_RX_RING_UOFFSET);
        return 1;
	}

    ioctl(f, GET_SETTINGS, settings);
    ioctl(f, START_RX_DMA, 0);

    for (i = 0; i < 1000; i++)
	{
		 rx.len = 1000;
		 ioctl(f, TX_MMAP_ALLOC, &rx);
		 for (j = rx.start; j < rx.start + rx.len; j++)
		 {
			 desc_el = &desc[j % settings.rx_desc_len];
		     desc_el->control = 1000;
		     desc_el->control |= DESC_SOF_EOF;
		 }
		 ioctl(f, TX_MMAP_PUT, &rx);
	}
	
	munmap(ring, MAX_RING);
	munmap(desc, POINTER_SIZE);
	
    close(f);
}
