#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <sys/mman.h>
#include <stdint.h>
#include "axi_dma.h"

char *buffer0;
char *buffer1;

int main(int argc, char **argv)
{
	fprintf(stderr, "UMMAP 0\n");
    int f = open(argv[1], O_RDWR);
    int i, j, failed;
	uint32_t *ptr0;
	uint32_t *ptr1;
	
	fprintf(stderr, "UMMAP 1\n");
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    fprintf(stderr, "UMMAP 2\n");
    buffer0 = mmap(NULL, 8*4096, PROT_READ | PROT_WRITE, MAP_SHARED, f, MMAP_ALLOC_UOFFSET);
	if (!buffer0)
	{
		fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_ALLOC_UOFFSET);
        return 1;
	}
	fprintf(stderr, "UMMAP 3\n");
	buffer1 = mmap(NULL, 8*4096, PROT_READ | PROT_WRITE, MAP_SHARED, f, MMAP_ALLOC_UOFFSET);
	fprintf(stderr, "UOFF: %x\n", MMAP_ALLOC_UOFFSET);
	if (!buffer1)
	{
		munmap(buffer0, 8*4096);
		fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_ALLOC_UOFFSET);
        return 1;
	}

    fprintf(stderr, "UMMAP 4\n");
    ptr0 = (uint32_t *)buffer0;
    for (i = 0; i < 2*4096; i++)
	{
		*ptr0 = i;
		ptr0++;
	}
	fprintf(stderr, "UMMAP 5\n");
	ptr1 = (uint32_t *)buffer1;
    for (i = 0; i < 2*4096; i++)
	{
		*ptr1 = 2*4096 - 1 - i;
		ptr1++;
	}
	fprintf(stderr, "UMMAP 6\n");
	failed = 0;
	ptr0 = (uint32_t *)buffer0;
	ptr1 = (uint32_t *)buffer1;
	for (i = 0; i < 2*4096; i++)
	{
		if (*ptr0 == *ptr1)
		{
			fprintf(stderr, "Error in map, two mappings are same at addr: %d.", i);
		}
	}
	fprintf(stderr, "UMMAP 7\n");
	munmap(buffer0, 8*4096);
	fprintf(stderr, "UMMAP 8\n");
	munmap(buffer1, 8*4096);
	fprintf(stderr, "UMMAP 9\n");
    close(f);
}
