/*!
 * \file        tsu.h
 * \brief       Header file for tsu2.c
 * \author      Vladimir Smotlacha <vs@cesnet.cz>
 * \author      Vojtech Vitek (V-Teq) <vojtech.vitek@gmail.com>
 * \date        2007-2010
 */

/*
 * Copyright (C) 2007-2010  CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id: tsu.h 7ce87c5 on Wed Nov 14 11:06:55 2012 +0100 by Mgr. Krej Radek $
 *
 */

#ifndef TSU_H
#define TSU_H

#define _BSD_SOURCE
#define _XOPEN_SOURCE
#define _GNU_SOURCE

#include <sys/types.h>
#include <sys/time.h>
#include <err.h>
#include <syslog.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/timex.h> //<linux/timex.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <math.h>

#include "l_fp.h"
#include "tsu_util.h"
#include "tsu_ntp.h"

/* Default file names */
/* path to lock file to avoid multiple running instances of tsuctl */
/* #define TSU_LOCK_FILE "/var/run/tsuctl.pid" */
#define TSU_LOCK_DIR "/etc/liberouter/run"
#define TSU_LOCK_FILE "/etc/liberouter/run/tsuctl.pid"
#define TSU_LOG_FILE "/var/log/tsuctl.log"
#define TSU_DRIFT_FILE "/var/tmp/tsuctl_drift.txt"

/* TSU_CV2 component name as in design.xml */
#define TSU_CV2_COMP_NAME               "TSU_CV2"

/* TSU_CV2 component size. */
#define TSU_CV2_COMP_SIZE               0x0030

/* TSU_CV2 register addresses. */
#define TSU_CV2_MI_DATA_LOW             0x000
#define TSU_CV2_MI_DATA_MIDDLE          0x004
#define TSU_CV2_MI_DATA_HIGH            0x008
#define TSU_CV2_CNTRL                   0x00C
#define TSU_CV2_STATE_REG               0x010
#define TSU_CV2_INTA                    0x014
#define TSU_CV2_PPSN_SELECT             0x018
#define TSU_CV2_FREQ                    0x01C
#define TSU_CV2_CLK_SELECT              0x020
#define TSU_CV2_RSTYPE                  0x024

/* TSU_CV2 register CNTRL operations. */
#define TSU_CV2_CNTRL_WRITE_INC         0x0
#define TSU_CV2_CNTRL_WRITE_RT          0x1
#define TSU_CV2_CNTRL_READ_INC          0x4
#define TSU_CV2_CNTRL_READ_RT           0x5
#define TSU_CV2_CNTRL_READ_PPS          0x7

#define SCAMPI_SYSLOG_FACILITY LOG_LOCAL0

/* TSU_GEN component name as in design.xml */
#define TSU_GEN_COMP_NAME               "TSU_GEN"

/* TSU_GEN register addresses. */

#define TSU_GEN_STATE_REG               0x10
#define TSU_GEN_PPS_SELECT              0x18
#define TSU_GEN_CLK_SELECT              0x20
#define TSU_GEN_SUP_CLK_PPS_REG         0x24

/*
 * clock frequency
 */

//  #define NOM_HZ	100000000L	/* 100 MHz */
// #define NOM_HZ	60000000L	/* 60 MHz */

/*
 * let we define new time unit: 1 xanosecond (1 xs) = 2^-30 s
 * XANOSEC - unit of time: 2^-30[s] ~ 9.313226*10^-9,
 */
#define XANOSEC 	1073741824L

/*
 *conversion xs -> ppm:   XANOSEC / 10^6
 */
#define PPM_COEF	1074

/*
 *  (double) 2^32
 */
#define EXP2_32	4294967296.


/* MAXFREQ - max diff of clock speed 0.5 [ms/s] = 5e-4/2^-30 [xs] ~ 536871
 *
 */

#define MAXFREQ 	536871L
#define MAXPHASE        536870912 /* max phase error (xs) */


struct timexspec {
	uint32_t tv_sec;	/* # of seconds since 1.1.1970 */
	int32_t tv_xsec;	/* # of xanoseconds */
};

#define MINSEC          256     /* min FLL update interval (s) */
#define MAXSEC          2048    /* max PLL update interval (s) */
#define SCALE_PPM       (65536 / 1000) /* crude xs/s to scaled PPM */



/* This limit (ns) will set the clock to `unsynchronized' */
#define NTP_PHASE_LIMIT (MAXPHASE << 2)


/*
 * Status codes (timex.status)
 */
#define STA_PLL         0x0001  /* enable PLL updates (rw) */
#define STA_PPSFREQ     0x0002  /* enable PPS freq discipline (rw) */
#define STA_PPSTIME     0x0004  /* enable PPS time discipline (rw) */
#define STA_FLL         0x0008  /* enable FLL mode (rw) */

#define STA_INS         0x0010  /* insert leap (rw) */
#define STA_DEL         0x0020  /* delete leap (rw) */
#define STA_UNSYNC      0x0040  /* clock unsynchronized (rw) */
#define STA_FREQHOLD    0x0080  /* hold frequency (rw) */

#define STA_PPSSIGNAL   0x0100  /* PPS signal present (ro) */
#define STA_PPSJITTER   0x0200  /* PPS signal jitter exceeded (ro) */
#define STA_PPSWANDER   0x0400  /* PPS signal wander exceeded (ro) */
#define STA_PPSERROR    0x0800  /* PPS signal calibration error (ro) */

#define STA_CLOCKERR    0x1000  /* clock hardware fault (ro) */
#define STA_NANO        0x2000  /* resolution (0 = us, 1 = ns) (ro) */
#define STA_MODE        0x4000  /* mode (0 = PLL, 1 = FLL) (ro) */
#define STA_CLK         0x8000  /* clock source (0 = A, 1 = B) (ro) */


/*
 * Clock states (time_state)
 */
#define TIME_OK         0       /* no leap second warning */
#define TIME_INS        1       /* insert leap second warning */
#define TIME_DEL        2       /* delete leap second warning */
#define TIME_OOP        3       /* leap second in progress */
#define TIME_WAIT       4       /* leap second has occurred */
#define TIME_ERROR      5       /* error (see status word) */

#define TX2FP(t, f)		/* convert TX to FP */ \
	do { \
		(f).l_i = (t).tv_sec; \
		(f).l_uf = ((t).tv_xsec << 2); \
	} while (0)

#define FP2TX(f, t)		/* convert FP to TX */ \
	do { \
		(t).tv_sec = (f).l_i; \
		(t).tv_xsec = ((f).l_uf >> 2); \
	} while (0)

#endif //TSU_H

