#! /bin/sh

log()
{
	echo "INFO: $@" > /dev/stderr
}

run()
{
	echo "$ $@" > /dev/stderr
	$@
}

new_test()
{
	echo "" > /dev/stderr
	echo "Test '$@'" > /dev/stderr
}

create_device_tree()
{
	test -d device-tree && log "Using the existing device-tree" && return 0
	test ! -d device-tree && mkdir device-tree || exit 1

	mkdir -p device-tree/axi_id@00000000
	echo -ne 'xlnx,axi_id-1.00.a\x00' > device-tree/axi_id@00000000/compatible
	echo -ne '\x00\x00\x00\x00\x00\x00\x00\x30' > device-tree/axi_id@00000000/reg

	log "Create a new device-tree"
	ls -l -R device-tree
}

create_fake()
{
	NEG="\x00\x00\x00\x00"
	echo -ne "$NEG" > fake

	STATUS="\xEF\xBE\xAD\xDE"   # DEADBEEF
	echo -ne "$STATUS" >> fake

	NAME0="\x4E\x69\x63\x65"    # 'Nice'
	echo -ne "$NAME0" >> fake

	NAME1="\x20\x44\x45\x53"    # ' DES'
	echo -ne "$NAME1" >> fake

	NAME2="\x49\x47\x4E\x20"    # 'IGN '
	echo -ne "$NAME2" >> fake

	NAME3="\x68\x65\x68\x65"    # 'hehe'
	echo -ne "$NAME3" >> fake

	VERSION="\x05\x00\x01\x00"  # 00010005
	echo -ne "$VERSION" >> fake

	TIME0="\x30\x31\x2F\x30"    # '01/0'
	echo -ne "$TIME0" >> fake
	
	TIME1="\x31\x2F\x31\x39"    # '1/19'
	echo -ne "$TIME1" >> fake

	TIME2="\x37\x30\x20\x30"    # '70 0'
	echo -ne "$TIME2" >> fake

	TIME3="\x30\x3A\x30\x30"    # '0:00'
	echo -ne "$TIME3" >> fake

	CUSTOM="\x01\x0A\x02\x0B"   # 0B020A01
	echo -ne "$CUSTOM" >> fake
}

test_print_help()
{
	new_test "Print help"
	run ./aidctl -h
}

test_list_ids_and_info()
{
	new_test "List devices"
	run ./aidctl -x device-tree -L

	new_test "Print info about devices"
	run ./aidctl -x device-tree -I
}

test_fail_on_neg()
{
	new_test "Fail on not working negation register"
	create_fake
	run ./aidctl -x device-tree -d fake && log "No failure?" && exit 1
}

test_default_command()
{
	new_test "Print info about the design (implicit command)"
	create_fake
	run ./aidctl -x device-tree -d fake -f

	new_test "Print info about the design (-D)"
	create_fake
	run ./aidctl -x device-tree -d fake -f -D
}

test_status_command()
{
	new_test "Read STATUS register"
	create_fake
	run ./aidctl -x device-tree -d fake -f -S

	new_test "Write COMMAND register && read STATUS (same address)"
	create_fake
	run ./aidctl -x device-tree -d fake -f -C 0x12345678
	run ./aidctl -x device-tree -d fake -f -S
}

create_device_tree

export DTREE_PATH="$PWD/../../libs/dtree/v1.0"
export HWIO_PATH="$PWD/../../../../sonda/swtools/hwio/v1.0"
export LD_LIBRARY_PATH="$DTREE_PATH:$HWIO_PATH:$HWIO_PATH/hwio-linux"

test_print_help
test_list_ids_and_info
test_fail_on_neg
test_default_command
test_status_command

rm -f fake
rm -Rf device-tree
