#ifndef ETHCTL_PARAM_H_INCLUDED
#define ETHCTL_PARAM_H_INCLUDED

// Command line arguments
#define ARGUMENTS   "C::G::N::O::B::S::T::U::P::M::J::V"

// max of 2 bit variable
#define BITM2 (((uint32_t)1)<<2)-1
// max of 6 bit variable
#define BITM6 (((uint32_t)1)<<6)-1
// max of 8 bit variable
#define BITM8 (((uint32_t)1)<<8)-1
// max of 16 bit variable
#define BITM16 (((uint32_t)1)<<16)-1
// max of 20 bit variable
#define BITM20 (((uint32_t)1)<<20)-1
// max of 32 bit variable
#define BITM32 (((uint64_t)1)<<32)-1
// max of 48 bit variable
#define BITM48 (((uint64_t)1)<<48)-1

// This structure is used to store commmand line parameters
struct hwio_tool_custom {
	uint32_t dscp_val;	// 6 bits
	uint32_t ecn_val;	// 2 bits
	uint32_t identification_val;	// 16 bits
	uint32_t flags_val;	// 2 bits
	uint32_t time_to_live_val;	// 8 bits
	uint32_t source_ip_val1;	// 32 bits
	uint32_t source_ip_val2;	// 32 bits
	uint32_t source_ip_val3;	// 32 bits
	uint32_t source_ip_val4;	// 32 bits
	uint32_t destination_ip_val1;	// 32 bits
	uint32_t destination_ip_val2;	// 32 bits
	uint32_t destination_ip_val3;	// 32 bits
	uint32_t destination_ip_val4;	// 32 bits
	uint32_t source_port_val;	// 16 bits
	uint32_t destination_port_val;	// 16 bits
	uint64_t source_MAC_val;	// 48 bits
	uint64_t destination_MAC_val;	// 48 bits
	uint32_t version_val;	// 4 bits
};

#define ADECTL_CUSTOM_INVALID { \
	~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0, ~0}

static inline int param32_invalid(uint32_t param)
{
	return param == ((uint32_t) ~0);
}

static inline int param64_invalid(uint64_t param)
{
	return param == ((uint64_t) ~0);
}

/* Print help message. */
void hwio_tool_help(const char *toolname, const struct hwio_tool_params *params);

/* Check parameters */
int check_params(struct hwio_tool_params *params);

/* Parse command line parameters. */
int custom_parser(int opt,const char *optarg, struct hwio_tool_params *params);

#endif // ADECTL_PARAM_H_INCLUDED 
