#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <unistd.h>
#include <stdbool.h>
#include <stdint.h>
#include "hwio.h"
#include "hwio_tool.h"
#include "hwio_comp.h"
#include "adectl.h"
#include "adectl_param.h"
#include "adectl_cmd.h"

struct hwio_comp_spec tool_compat[]={
	{"debug", "axi-dataexport", HWIO_VER2(1, 0)},
	{"ug4-150", "axi-dataexport", HWIO_VER3(1, 0, HWIO_VERSION_NA)},
	{"xlnx", "axi-dataexport", HWIO_VER3(1, 0, 'a')},
	{"xlnx", "axi-dataexport", HWIO_VER3(2, 0, 'a')},	
	HWIO_COMPAT_END
};

/* Main */
int main(int argc, char *argv[]) {
	struct hwio_tool_custom cust_params = ADECTL_CUSTOM_INVALID;
	struct hwio_tool_params params = hwio_tool_params_new (&cust_params, argc, argv);

	// Parse command line parameters
	int p = hwio_tool_params_parse(&params, &custom_parser, ARGUMENTS);
	if (p == HWIO_TOOL_PARAMS_FAILED)
	{
		return HWIO_TOOL_EARGS;
	}
	else if (p == HWIO_TOOL_PARAMS_EXIT)
	{
		return EXIT_SUCCESS;
	}
	hwio_tool_verbose(&params, 1, "Arguments parsed successfully");
	hwio_tool_verbose(&params, 1, "Command: -%c", params.cmd.code);
	hwio_tool_verbose(&params, 1, "Argument: %s", params.cmd.arg);
	hwio_tool_verbose(&params, 1, "Arguments are valid");
	hwio_tool_verbose(&params, 1, "Performing command");

	// Perform commands
	switch(params.cmd.code) {
		case 'I':
			return hwio_tool_exec_generic(&params,tool_compat,&hwio_tool_comp_info,&hwio_tool_error_handler);
		case 'L':
			return hwio_tool_exec_generic(&params,tool_compat,&hwio_tool_comp_name,&hwio_tool_error_handler);
		case 'U':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_srcport,&hwio_tool_error_handler);
		case 'P':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_dstport,&hwio_tool_error_handler);
		case 'S':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_dscp,&hwio_tool_error_handler);
		case 'C':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_ecn,&hwio_tool_error_handler);
		case 'N':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_identification,&hwio_tool_error_handler);
		case 'G':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_flags,&hwio_tool_error_handler);
		case 'T':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_ttl,&hwio_tool_error_handler);
		case 'O':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_srcip,&hwio_tool_error_handler);
		case 'B':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_dstip,&hwio_tool_error_handler);
		case 'M':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_dstmac,&hwio_tool_error_handler);
		case 'J':
			return hwio_tool_exec_generic(&params,tool_compat,&rw_srcmac,&hwio_tool_error_handler);
		case 'V':
			return hwio_tool_exec_generic(&params,tool_compat,&r_version,&hwio_tool_error_handler);
		case '\0':
			return hwio_tool_error(HWIO_TOOL_EARGS,"No command was specified");
		default:
			return hwio_tool_error(HWIO_TOOL_EARGS,"Command -%c is not implemented",params.cmd.code);
	}
	hwio_tool_verbose(&params, 1, "Command performed successfully - EXITING");
    
	return EXIT_SUCCESS;
} 
