#
# Author: Ing. Jiri Petrlik (ipetrlik@fit.vutbr.cz)
# This software was supported by IT4Innovations Centre of Excellence CZ.1.05/1.1.00/02.0070.
#
# License:
# BUT OPEN SOURCE LICENCE
# Version 1.
# Copyright (c) 2013, Brno University of Technology, Antonnsk 548/1, 601 90, Czech Republic
# --------------------------------------------------------------------------
# BY INSTALLING, COPYING OR OTHER USES OF SOFTWARE YOU ARE DECLARING
# THAT YOU AGREE WITH THE TERMS AND CONDITIONS OF THIS LICENCE
# AGREEMENT. IF YOU DO NOT AGREE WITH THE TERMS AND CONDITIONS, DO
# NOT INSTAL, COPY OR USE THE SOFTWARE.
# 
# IF YOU DO NOT POSESS A VALID LICENCE, YOU ARE NOT AUTHORISED TO
# INSTAL, COPY OR OTHERWISE USE THE SOTWARE.
# 
# Definitions:
# 
# For the purpose of this agreement, Software shall mean a computer
# program (a group of computer programs functional as a unit) capable
# of copyright protection and accompanying documentation.
# 
# Work based on Software shall mean a work containing Software or a
# portion of it, either verbatim or with modifications and/or
# translated into another language, or a work based on Software.
# Portions of work not containing a portion of Software or not based
# on Software are not covered by this definition, if it is capable
# of independent use and distributed separately.
# 
# Source code shall mean all the source code for all modules of
# Software, plus any associated interface definition files, plus the
# scripts used to control compilation and installation of the executable
# program. Source code distributed with Software need not include
# anything that is normally distributed (in either source or binary
# form) with the major components (compiler, kernel, and so on) of
# the operating system on which the executable program runs.
# 
# Anyone who uses Software becomes User. User shall abide by this
# licence agreement.
# 
# BRNO UNIVERSITY OF TECHNOLOGY GRANTS TO USER A LICENCE TO USE
# SOFTWARE ON THE FOLLOWING TERMS AND CONDITIONS:
# 
# 1. User may use Software for any purpose, commercial or noncommercial,
# without a need to pay any licence fee.
# 
# 2. User may copy and distribute verbatim copies of executable
# Software with source code as he/she received it, in any medium,
# provided that User conspicuously and appropriately publishes on
# each copy an appropriate copyright notice and disclaimer of warranty;
# keeps intact all the notices that refer to this licence and to the
# absence of any warranty; and give any other recipients of Software
# a copy of this licence along with Software. User may charge a fee
# for the physical act of transferring a copy, and may offer warranty
# protection in exchange for a fee.
# 
# 3. User may modify his/her copy or copies of Software or any portion
# of it, thus forming a work based on Software, and copy and distribute
# such modifications or work, provided that User clearly states this
# work is modified Software. These modifications or work based on
# software may be distributed only under the terms of section 2 of
# this licence agreement, regardless if it is distributed alone or
# together with other work. Previous sentence does not apply to mere
# aggregation of another work not based on software with Software (or
# with a work based on software) on a volume of a storage or distribution
# medium.
# 
# 4. User shall accompany copies of Software or work based on software
# in object or executable form with:
# 
# a) the complete corresponding machine-readable source code, which
# must be distributed on a medium customarily used for software
# interchange; or,
# b) written offer, valid for at least three years, to give any third
# party, for a charge no more than actual cost of physically performing
# source distribution, a complete machine-readable copy of the
# corresponding source code, to be distributed on a medium customarily
# used for software interchange; or,
# c) the information User received as to the offer to distribute
# corresponding source code. (This alternative is allowed only for
# noncommercial distribution and only if User received the program
# in objects code or executable form with such an offer, in accord
# with subsection b above.)
# 
# 5. User may not copy, modify, grant sublicences or distribute
# Software in any other way than expressly provided for in this
# licence agreement. Any other copying, modifying, granting of
# sublicences or distribution of Software is illegal and will
# automatically result in termination of the rights granted by this
# licence. This does not affect rights of third parties acquired in
# good faith, as long as they abide by the terms and conditions of
# this licence agreement.
# 
# 6. User may not use and/or distribute Software, if he/she cannot
# satisfy simultaneously obligations under this licence and any other
# pertinent obligations.
# 
# 7. User is not responsible for enforcing terms of this agreement
# by third parties.
# 
# 8. BECAUSE SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
# FOR SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT
# WHEN OTHERWISE STATED IN WRITING, BUT PROVIDES SOFTWARE "AS IS"
# WITHOUT WARRANTY OF ANY KIND,EITHER EXPRESSED OR IMPLIED,INCLUDING,BUT
# NOT LIMITED TO,THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE.THE ENTIRE RISK AS TO THE QUALITY AND
# PERFORMANCE OF SOFTWARE IS WITH USER. SHOULD SOFTWARE PROVE
# DEFECTIVE, USER SHALL ASSUME THE COST OF ALL NECESSARY SERVICING,
# REPAIR OR CORRECTION.
# IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
# WILL BRNO UNIVERSITY OF TECHNOLOGY BE LIABLE FOR DAMAGES, INCLUDING
# ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
# OUT OF THE USE OR INABILITY TO USE SOFTWARE (INCLUDING BUT NOT
# LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES
# SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF SOFTWARE TO OPERATE
# WITH ANY OTHER PROGRAMS).
# 
# Final provisions:
# Any provision of this licence agreement that is prohibited,
# unenforceable, or not authorized in any jurisdiction shall, as to
# such jurisdiction, be ineffective to the extent of such prohibition,
# unenforceability, or non-authorization without invalidating or
# affecting the remaining provisions.
# 
# This licence agreement provides in essentials the same extent of
# rights as the terms of GNU GPL version 2 and Software fulfils the
# requirements of Open Source software.
# 
# This agreement is governed by law of the Czech Republic. In case
# of a dispute, the jurisdiction shall be that of courts in the Czech
# Republic.
# 
# By installing, copying or other use of Software User declares he/she
# has read this terms and conditions, understands them and his/her
# use of Software is a demonstration of his/her free will absent of
# any duress.
###############################################################################

fitness<-function(chromosome) {
	a<-oneMaxFitness(chromosome);
	b<-zeroMaxFitness(chromosome);
	
	return(c(a,b));
}

nonDominatedSorting<-function(fitnessMatrix) {
	setSize<-nrow(fitnessMatrix);
	result<-numeric(setSize);
	
	SP<-list();
	NP<-rep(0,setSize);
	
	dominationMatrix<-dominateMatrix(fitnessMatrix);
	for(p in 1:nrow(fitnessMatrix)) {
		domVector<-dominationMatrix[p,];
		
		SP<-c(SP,list(domVector));
		NP[domVector]<-NP[domVector]+1;
	}
	
	frontNumber<-1;
	while(sum(NP!=-1)>0) {
		front<-which(NP==0);
		NP[front]<-(-1);
		
		for(q in front) {
			SQ<-SP[[q]];
			NP[SQ]<-NP[SQ]-1;
		}
		
		result[front]<-frontNumber;
		frontNumber<-frontNumber+1;
	}
	
	return(result);
}

reverseGenerationalDistance<-function(newFront,oldFront) {
	dVector<-numeric();
	for(i in seq(nrow(newFront))) {
		row<-newFront[i,];
		dValue<-min(apply(oldFront,1,function(x,y) {sqrt(sum(x-y)^2)},row));
		dVector[i]<-dValue;
	}
	distance<-sqrt(sum(dVector^2));
	return(distance);
}

spacing<-function(front) {
	d<-numeric();
	
	for(i in seq(nrow(front))) {
		row<-front[i,];
		d[i]<-min(apply(front,1,function(x,y) {return(sum(abs(x-y)))},row)[-i]);
	}
	
	meanD<-mean(d);
	sp<-sqrt(mean((d-meanD)^2));
	
	return(sp);
}

tournamentSelection<-function(fitnessVector) {
	popSize<-length(fitnessVector);
	
	selected1<-trunc(runif(n=popSize,min=1,max=popSize));
	selected2<-trunc(runif(n=popSize,min=1,max=popSize));
	
	fitnessSelected1<-fitnessVector[selected1];
	fitnessSelected2<-fitnessVector[selected2];
	
	decision<-fitnessSelected1<fitnessSelected2;
	selected<-1:popSize;
	selected[decision]<-selected1[decision];
	selected[!decision]<-selected2[!decision];
	
	return(selected);
}

tournamentSelectionOrdered<-function(solutionCount) {
	result<-numeric(solutionCount);
	
	parentA<-trunc(runif(n=solutionCount,min=1,max=solutionCount+1));
	parentB<-trunc(runif(n=solutionCount,min=1,max=solutionCount+1));
	
	selection<-parentA<parentB;
	
	result[selection]=parentA[selection];
	result[!selection]=parentB[!selection];
	
	return(result);
}

crowdingDistanceAssignment<-function(fitnessMatrix) {
	setSize<-nrow(fitnessMatrix);
	if(setSize>=3) {
		fitnessCount<-ncol(fitnessMatrix);
		crowdingDistance<-rep(0,setSize);
		
		for(i in 1:ncol(fitnessMatrix)) {
			fitnessVector<-fitnessMatrix[,i];
			ord<-order(fitnessVector);
			fitnessVector<-fitnessVector[ord];
			
			tmpCrowdingDistance<-rep(0,setSize);
			tmpCrowdingDistance[ord[c(1,setSize)]]<-Inf;
			tmpCrowdingDistance[ord[2:(setSize-1)]]<-
					tmpCrowdingDistance[ord[2:(setSize-1)]]+abs(fitnessVector[1:(setSize-2)]-fitnessVector[2:(setSize-1)]);
			tmpCrowdingDistance[ord[2:(setSize-1)]]<-
					tmpCrowdingDistance[ord[2:(setSize-1)]]+abs(fitnessVector[3:setSize]-fitnessVector[2:(setSize-1)]);
			
			crowdingDistance<-crowdingDistance+tmpCrowdingDistance;
		}
	}
	else {
		crowdingDistance<-rep(Inf,setSize);
	}
	
	return(crowdingDistance);
}

basicStatistic<-function(statistic,popFitness,population) {
	if(!is.list(statistic)) {
		statistic<-list(
				minFitness=numeric(),
				meanFitness=numeric(),
				medianFitness=numeric(),
				maxFitness=numeric(),
				standardDeviation=numeric());
	}
	
	minFitness<-min(popFitness);
	meanFitness<-mean(popFitness);
	medianFitness<-median(popFitness);
	maxFitness<-max(popFitness);
	standardDeviation<-sd(popFitness);
	
	statistic$minFitness<-c(statistic$minFitness,minFitness);
	statistic$meanFitness<-c(statistic$meanFitness,meanFitness);
	statistic$medianFitness<-c(statistic$medianFitness,medianFitness);
	statistic$maxFitness<-c(statistic$maxFitness,maxFitness);
	statistic$standardDeviation<-c(statistic$standardDeviation,standardDeviation);
	
	return(statistic);
}

multiobjectiveStatistic<-function(statistic,fitnessMatrix,population) {
	fitnessCount<-ncol(fitnessMatrix);
	frontNumbers<-nonDominatedSorting(fitnessMatrix);
	firstFrontMatrix<-fitnessMatrix[frontNumbers==1,];
	firstFrontMatrix<-unique(firstFrontMatrix);
	if(is.vector(firstFrontMatrix)==TRUE) {
		firstFrontMatrix<-matrix(firstFrontMatrix,nrow=1);
	}
	
	if(!is.list(statistic)) {
		frontDistances<-list(previousFront=firstFrontMatrix,distance=numeric());
		statistic<-list(paretoFrontSize=numeric(),
				frontDistances=frontDistances,
				spacing=numeric(),
				diversity=numeric());
		statistic$fitnessStatistic<-replicate(fitnessCount,list(FALSE));
		statistic$maxSpread<-replicate(fitnessCount,numeric());
	}
	else {
		frontDistances<-statistic$frontDistances;
		distance<-reverseGenerationalDistance(firstFrontMatrix,frontDistances$previousFront);
		frontDistances$previousFront<-firstFrontMatrix;
		frontDistances$distance<-c(frontDistances$distance,distance);
		statistic$frontDistances<-frontDistances;
	}
	
	for(i in 1:fitnessCount) {
		statistic$fitnessStatistic[[i]]<-basicStatistic(statistic$fitnessStatistic[[i]],fitnessMatrix[,i],population);
		statistic$maxSpread[[i]]<-c(statistic$maxSpread[[i]],max(firstFrontMatrix[,i])-min(firstFrontMatrix[,i]));
	}
	
	frontNumbers<-nonDominatedSorting(fitnessMatrix);
	firstFrontMatrix<-fitnessMatrix[frontNumbers==1,];
	paretoFrontSize<-nrow(unique(firstFrontMatrix));
	statistic$paretoFrontSize<-c(statistic$paretoFrontSize,paretoFrontSize);
	sp<-spacing(fitnessMatrix);
	statistic$spacing<-c(statistic$spacing,sp);
	
	firstFrontPopulation<-population[frontNumbers==1];
	diversity<-length(unique(firstFrontPopulation));
	statistic$diversity<-c(statistic$diversity,diversity);
	
	return(statistic);
}

multimodalNsga2Algorithm<-function(initGenome,
		multiobjectiveFitness,crossover,mutation,
		popSize=100,generations=100,
		statisticFunction=FALSE,repair=identity,fitnessParameters=list(),...) {
	statistic<-numeric();
	
	population<-list();
	population<-replicate(popSize,list(initGenome()));
	population<-lapply(population,repair);
	
	fitnessMatrix<-applyMultiobjectiveFitness(population,multiobjectiveFitness,fitnessParameters,...);
	rank<-nonDominatedSorting(fitnessMatrix);
	popSelection<-tournamentSelection(rank);
	selectedPopulation<-population[popSelection];
	ofspringPopulation<-list();
	for(i in 1:(popSize/2)) {
		ind1<-2*(i-1)+1;
		ind2<-2*(i-1)+2;
		offsprings<-crossover(selectedPopulation[[ind1]],selectedPopulation[[ind2]]);
		offsprings[[1]]<-mutation(offsprings[[1]]);
		offsprings[[2]]<-mutation(offsprings[[2]]);
		offsprings[[1]]<-repair(offsprings[[1]]);
		offsprings[[2]]<-repair(offsprings[[2]]);
		ofspringPopulation<-c(ofspringPopulation,offsprings);
	}
	
	for(generation in 1:generations) {
		oldFitnessMatrix<-fitnessMatrix;
		
		fitnessMatrix<-applyMultiobjectiveFitness(ofspringPopulation,multiobjectiveFitness,fitnessParameters,...);
		fitnessMatrix<-rbind(oldFitnessMatrix,fitnessMatrix);
		populationsUnion<-c(population,ofspringPopulation);
		frontNumbers<-nonDominatedSorting(fitnessMatrix);
		
		newPopulationSelection<-logical();
		actualFrontN<-1;
		while((length(newPopulationSelection)<popSize) && (actualFrontN<=max(frontNumbers))) {
			actualFront<-which(frontNumbers==actualFrontN);
			actualFront<-actualFront[!duplicated(populationsUnion[actualFront])];
			if(length(actualFront)+length(newPopulationSelection)<=popSize) {
				frontFitnessMatrix<-fitnessMatrix[actualFront,];
				if(is.vector(frontFitnessMatrix)==TRUE) {
					frontFitnessMatrix<-matrix(frontFitnessMatrix,nrow=1);
				}
				crowdingDistance<-crowdingDistanceAssignment(frontFitnessMatrix);
				ord<-order(crowdingDistance,decreasing=TRUE);
				
				newPopulationSelection<-c(newPopulationSelection,actualFront[ord]);
			}
			else {
				actualFront<-which(frontNumbers==actualFrontN);
				frontFitnessMatrix<-fitnessMatrix[actualFront,];
				dupl<-!duplicated(frontFitnessMatrix);
				
				if(length(newPopulationSelection)+sum(dupl)<=popSize) {
					newPopulationSelection<-c(newPopulationSelection,actualFront[dupl]);
					frontFitnessMatrix<-frontFitnessMatrix[!dupl,];
					if(is.vector(frontFitnessMatrix)) {
						frontFitnessMatrix<-matrix(frontFitnessMatrix,nrow=1);
					}
					actualFront<-actualFront[!dupl];
					
					missing<-popSize-length(newPopulationSelection);
					chosen<-sample(length(actualFront),missing);
					newPopulationSelection<-c(newPopulationSelection,actualFront[chosen]);
				}
				else {
					missing<-popSize-length(newPopulationSelection);
					
					frontFitnessMatrix<-fitnessMatrix[actualFront,];
					if(is.vector(frontFitnessMatrix)==TRUE) {
						frontFitnessMatrix<-matrix(frontFitnessMatrix,nrow=1);
					}
					crowdingDistance<-crowdingDistanceAssignment(frontFitnessMatrix);
					ord<-order(crowdingDistance,decreasing=TRUE);
					newPopulationSelection<-c(newPopulationSelection,actualFront[ord[1:missing]]);
				}
			}
			
			actualFrontN<-actualFrontN+1;
		}
		
		if(length(newPopulationSelection)<length(population)) {
			randomSolutions<-replicate(length(population)-length(newPopulationSelection),list(initGenome()));
			randomSolutions<-lapply(randomSolutions,repair);
			
			population[1:length(newPopulationSelection)]<-populationsUnion[newPopulationSelection];
			population[(length(newPopulationSelection)+1):length(population)]<-randomSolutions;
			
			fitnessMatrix<-fitnessMatrix[newPopulationSelection,];
			if(is.vector(fitnessMatrix)==TRUE) {
				fitnessMatrix<-matrix(fitnessMatrix,nrow=1);
			}
			fitnessMatrixRND<-applyMultiobjectiveFitness(population[(length(newPopulationSelection)+1):length(population)],
					multiobjectiveFitness,fitnessParameters,...);
			if(is.vector(fitnessMatrixRND)==TRUE) {
				fitnessMatrixRND<-matrix(fitnessMatrixRND,nrow=1);
			}
			fitnessMatrix<-rbind(fitnessMatrix,fitnessMatrixRND);
		}
		else {
			population<-populationsUnion[newPopulationSelection];
			fitnessMatrix<-fitnessMatrix[newPopulationSelection,];
		}
		
		popSelection<-tournamentSelectionOrdered(popSize);
		selectedPopulation<-population[popSelection];
		ofspringPopulation<-list();
		for(i in 1:(popSize/2)) {
			ind1<-2*(i-1)+1;
			ind2<-2*(i-1)+2;
			offsprings<-crossover(selectedPopulation[[ind1]],selectedPopulation[[ind2]]);
			offsprings[[1]]<-mutation(offsprings[[1]]);
			offsprings[[2]]<-mutation(offsprings[[2]]);
			offsprings[[1]]<-repair(offsprings[[1]]);
			offsprings[[2]]<-repair(offsprings[[2]]);
			ofspringPopulation<-c(ofspringPopulation,offsprings);
		}
		
		if(class(statisticFunction)=="function") {
			statistic<-statisticFunction(statistic,fitnessMatrix,population);
		}
	}
	
	fitnessMatrix<-applyMultiobjectiveFitness(population,multiobjectiveFitness,fitnessParameters,...);
	frontNumbers<-nonDominatedSorting(fitnessMatrix);
	ord<-order(frontNumbers);
	population<-population[ord];
	fitnessMatrix<-fitnessMatrix[ord,];
	
	return(list(population=population,fitnessMatrix=fitnessMatrix,statistic=statistic));
}
