\name{featureSelectionRegressionGA}
\alias{featureSelectionRegressionGA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Search for optimal inputs (features) for SVR.
}
\description{
Multiobjective search for optimal inputs (features) for support vector regression.
}
\usage{
featureSelectionRegressionGA(dataTrain, dataTest, predictedVariable, features,
  popSize = 40, generations = 100, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dataTrain}{
    Data frame with training data for SVR.
}
  \item{dataTest}{
    Data frame with testing data for validation of trained models.
}
  \item{predictedVariable}{
    Column in dataTrain and dataTest which contains correct results.
}
  \item{features}{
    The vector with names of columns, which contains inputs for SVR.
}
  \item{popSize}{
    Size of populotaion of multimodal NSGAII algorithm.
}
  \item{generations}{
    The number of generations to evolve.
}
  \item{\dots}{
    Settings of SVR. These parameters corresponds to parameters of command svm
    in e1071 package.
}
}
\value{
Function returns list with these components:
  \item{results }{Data frame with summary of obtained results}
  \item{modelList }{List of obtained models}
  \item{resultsList}{List with values obtained by models for train set and test set}
  \item{statistic}{Information about convergence of the genetic algorithm}
}
\references{
[1] Deb, Kalyanmoy, Raji Reddy, A, Reliable classification of two-class cancer data using evolutionary algorithms, Biosystems, 2003
}
\author{
Ing. Jiri Petrlik
}

\examples{
# Example of regression task 1:
library(SVMFeatureSelectionSystem);
library(rpart);

car90$Country<-as.numeric(car90$Country);
car90$Model2<-as.numeric(car90$Model2);
car90$Reliability<-as.numeric(car90$Reliability);
car90$Rim<-as.numeric(car90$Rim);
car90$Steering<-as.numeric(car90$Steering);
car90$Tires<-as.numeric(car90$Tires);
car90$Trans1<-as.numeric(car90$Trans1);
car90$Trans2<-as.numeric(car90$Trans2);
car90$Type<-as.numeric(car90$Type);

features<-colnames(car90)[colnames(car90)!="Price"];
predictedVariable<-"Price";

shuffleCar90<-car90[sample(nrow(car90)),]
trainData<-shuffleCar90[1:80,];
testData<-shuffleCar90[81:111,];

results<-featureSelectionRegressionGA(trainData,testData,predictedVariable,
  features);

# Example of regression task 2:
library(SVMFeatureSelectionSystem);
library(mlbench);

sim<-mlbench.friedman1(100);
trainData<-as.data.frame(sim$x);
trainData<-cbind(trainData,V11=sim$y);

sim<-mlbench.friedman1(100);
testData<-as.data.frame(sim$x);
testData<-cbind(testData,V11=sim$y);

features<-colnames(trainData)[1:10];
predictedVariable<-"V11";

results<-featureSelectionRegressionGA(trainData,testData,predictedVariable,
  features);
}