\name{featureSelectionClassificationGA}
\alias{featureSelectionClassificationGA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Search for optimal inputs (features) for SVM.
}
\description{
Multiobjective search for optimal inputs (features) for support vector machine.
}
\usage{
featureSelectionClassificationGA(dataTrain, dataTest, predictedVariable,
  features, popSize = 40, generations = 100, ...)
}

\arguments{
  \item{dataTrain}{
    Data frame with training data for SVM.
}
  \item{dataTest}{
    Data frame with testing data for validation of trained models.
}
  \item{predictedVariable}{
    Column in dataTrain and dataTest which contains correct results.
}
  \item{features}{
    The vector with names of columns, which contains inputs for SVM. 
}
  \item{popSize}{
    Size of populotaion of multimodal NSGAII algorithm.
}
  \item{generations}{
    The number of generations to evolve.
}
  \item{\dots}{
    Settings of SVM. These parameters corresponds to parameters of command svm
    in e1071 package. 
}
}
\value{
Function returns list with these components:
  \item{results }{Data frame with summary of obtained results}
  \item{modelList }{List of obtained models}
  \item{resultsList }{List with values obtained by models for train set and test set}
  \item{statistic }{Information about convergence of the genetic algorithm}
}
\references{
[1] Deb, Kalyanmoy, Raji Reddy, A, Reliable classification of two-class cancer data using evolutionary algorithms, Biosystems, 2003
}
\author{
Ing. Jiri Petrlik
}

\examples{
# Example of classification task 1:

library(SVMFeatureSelectionSystem);
library(classifly);

features<-colnames(olives)[3:10];
predictedVariable<-colnames(olives)[2];

shuffleOlives<-olives[sample(nrow(olives)),];
dataTrain<-shuffleOlives[1:286,];
dataTest<-shuffleOlives[287:572,];

results<-featureSelectionClassificationGA(dataTrain,dataTest,predictedVariable,
  features);

# Example of classification task 2:

library(SVMFeatureSelectionSystem);
library(plsgenomics);
library(stringr);

data(Colon);
ColonDataset<-as.data.frame(Colon$X);
colnames(ColonDataset)<-str_trim(Colon$gene.names);
ColonDataset<-cbind(ColonDataset,result=Colon$Y);

ColonDataset[ColonDataset[,"result"]==1,"result"]<-"normal";
ColonDataset[ColonDataset[,"result"]==2,"result"]<-"tumor";
ColonDataset[,"result"]<-as.factor(ColonDataset[,"result"]);

ColonDataset<-ColonDataset[sample(nrow(ColonDataset)),];
trainColon<-ColonDataset[1:31,];
testColon<-ColonDataset[32:62,];

features<-colnames(trainColon)[1:2000];
predictedVariable<-colnames(trainColon)[2001];

results<-featureSelectionClassificationGA(trainColon,testColon,
  predictedVariable,features,popSize=100,generations=200);
}


%% ~Make other sections like Warning with \section{Warning }{....} ~
