uniformBinnaryCrossoverBase <-
function(parent1,parent2,pCross=0.7) {
	rnd<-runif(1);
	if(rnd<=pCross) { # perform crossover
		chromosomeLength<-length(parent1);
		
		rnd<-runif(chromosomeLength);
		decision<-rnd<0.5;
		
		offspring1<-logical(chromosomeLength);
		offspring2<-logical(chromosomeLength);
		
		offspring1[decision]<-parent1[decision];
		offspring1[!decision]<-parent2[!decision];
		
		offspring2[decision]<-parent2[decision];
		offspring2[!decision]<-parent1[!decision];
		
		return(list(offspring1,offspring2));
	}
	else { # Don't perform crossover. Return parents.
		return(list(parent1,parent2));
	}
}
