multiobjectiveStatistic <-
function(statistic,fitnessMatrix,population) {
	fitnessCount<-ncol(fitnessMatrix);
	frontNumbers<-nonDominatedSorting(fitnessMatrix);
	firstFrontMatrix<-fitnessMatrix[frontNumbers==1,];
	firstFrontMatrix<-unique(firstFrontMatrix);
	if(is.vector(firstFrontMatrix)==TRUE) {
		firstFrontMatrix<-matrix(firstFrontMatrix,nrow=1);
	}
	
	if(!is.list(statistic)) {
		frontDistances<-list(previousFront=firstFrontMatrix,distance=numeric());
		statistic<-list(paretoFrontSize=numeric(),
				frontDistances=frontDistances,
				spacing=numeric(),
				diversity=numeric());
		statistic$fitnessStatistic<-replicate(fitnessCount,list(FALSE));
		statistic$maxSpread<-replicate(fitnessCount,numeric());
	}
	else {
		frontDistances<-statistic$frontDistances;
		distance<-reverseGenerationalDistance(firstFrontMatrix,frontDistances$previousFront);
		frontDistances$previousFront<-firstFrontMatrix;
		frontDistances$distance<-c(frontDistances$distance,distance);
		statistic$frontDistances<-frontDistances;
	}
	
	for(i in 1:fitnessCount) {
		statistic$fitnessStatistic[[i]]<-basicStatistic(statistic$fitnessStatistic[[i]],fitnessMatrix[,i],population);
		statistic$maxSpread[[i]]<-c(statistic$maxSpread[[i]],max(firstFrontMatrix[,i])-min(firstFrontMatrix[,i]));
	}
	
	frontNumbers<-nonDominatedSorting(fitnessMatrix);
	firstFrontMatrix<-fitnessMatrix[frontNumbers==1,];
	paretoFrontSize<-nrow(unique(firstFrontMatrix));
	statistic$paretoFrontSize<-c(statistic$paretoFrontSize,paretoFrontSize);
	sp<-spacing(fitnessMatrix);
	statistic$spacing<-c(statistic$spacing,sp);
	
	firstFrontPopulation<-population[frontNumbers==1];
	diversity<-length(unique(firstFrontPopulation));
	statistic$diversity<-c(statistic$diversity,diversity);
	
	return(statistic);
}
