featureSelectionClassificationGA <-
function(dataTrain,dataTest,predictedVariable,features,
		popSize=40,generations=100,...) {
	
	multiobjectiveFitness<-function(chromosome,trainData,testData,...) {
		selection<-c(predictedVariable,features[chromosome]);
		trainData<-trainData[,selection];
		testData<-testData[,selection];
		
		rowNumber<-nrow(testData);
		tmpTestData<-testData[,2:ncol(testData)];
		if(is.vector(tmpTestData)==TRUE) {
			tmpTestData<-as.matrix(tmpTestData,ncol=1);
		}
		tmpTestData<-na.omit(tmpTestData);
		fitness3<-1-(nrow(tmpTestData)/rowNumber);
		
		trainData<-na.omit(trainData);
		testData<-na.omit(testData);
		
		if((nrow(trainData)<10) || (nrow(testData)<10)) {
			return(c(Inf,Inf,Inf));
		}
		
		featureNames<-features[chromosome];
		f<-paste(featureNames,collapse="+");
		f<-paste(predictedVariable,f,sep="~");
		
		model<-svm(as.formula(f),data=trainData,...);
		tmpData<-testData[,featureNames];
		if(is.vector(tmpData)==TRUE) {
			tmpData<-as.matrix(tmpData,ncol=1);
			colnames(tmpData)<-featureNames;
		}
		predicted<-predict(model,as.matrix(tmpData));
		
		real<-testData[,predictedVariable];
		missed<-predicted!=real;
		fitness1<-sum(missed)/length(real);
		
		fitness2<-sum(chromosome);
		
		result<-c(fitness1,fitness2,fitness3);
		if(length(result)!=3) {
			stop("problem");
		}
		return(result);
	}
	
	if(!(predictedVariable %in% colnames(dataTrain))) {
		stop("Predikovana velicina neni v trenovaci sade");
	}
	if(!(predictedVariable %in% colnames(dataTest))) {
		stop("Predikovana velicina neni v testovaci sade");
	}
	
	if(!(all(features %in% colnames(dataTrain)))) {
		stop("Nektera vstupni promenna neni v trenovaci mnozine");
	}
	if(!(all(features %in% colnames(dataTest)))) {
		stop("Nektera vstupni promenna neni v testovaci mnozine");
	}
	
	dataTrain<-dataTrain[,c(predictedVariable,features)];
	dataTest<-dataTest[,c(predictedVariable,features)];
	
	gaResult<-multimodalNsga2Algorithm(initBinaryChromosome(length(features),0.1),
			multiobjectiveFitness,
			uniformBinnaryCrossover(),
			binaryMutation(),
			popSize=popSize,
			generations=generations,
			statistic=multiobjectiveStatistic,
			repair=fsReapair,
			list(trainData=dataTrain,testData=dataTest),...);
	
	features2<-character();
	for(chromosome in gaResult$population) {
		featuresTmp<-features[chromosome];
		featuresTmp<-paste(featuresTmp,collapse=",");
		features2<-c(features2,featuresTmp);
	}
	
	solution<-1:length(gaResult$population);
	front<-nonDominatedSorting(gaResult$fitnessMatrix);
	
	results<-data.frame(
			solution=solution,
			front=front,
			features=features2,
			missclasified=gaResult$fitnessMatrix[,1],
			featureCount=gaResult$fitnessMatrix[,2],
			unavailable=gaResult$fitnessMatrix[,3]
	);
	
	modelList<-list();
	resultsList<-list();
	for(chromosome in gaResult$population) {
		selection<-c(predictedVariable,features[chromosome]);
		tmpTrain<-dataTrain[,selection];
		tmpTrain<-na.omit(tmpTrain);
		
		if(nrow(tmpTrain)<10) {
			modelList[[length(modelList)]]<-NA;
			resultsList[[length(resultsList)+1]]<-NA;
		}
		else {
			featureNames<-features[chromosome];
			f<-paste(featureNames,collapse="+");
			f<-paste(predictedVariable,f,sep="~");
			
			model<-svm(as.formula(f),data=tmpTrain,...);
			modelList[[length(modelList)+1]]<-model;
			
			trainResults<-predict(model,tmpTrain);
			trainResults<-list(real=tmpTrain[,predictedVariable],classification=trainResults);
			names(trainResults[[1]])<-rownames(tmpTrain);
			names(trainResults[[2]])<-rownames(tmpTrain);
			
			tmpTest<-dataTest[,selection];
			tmpTest<-na.omit(tmpTest);
			testResults<-predict(model,tmpTest);
			testResults<-list(real=tmpTest[,predictedVariable],classification=testResults);
			names(testResults[[1]])<-rownames(tmpTest);
			names(testResults[[2]])<-rownames(tmpTest);
			
			resultsList[[length(resultsList)+1]]<-list(trainResults=trainResults,testResults=testResults);
		}
	}
	
	return(list(results=results,modelList=modelList,resultsList=resultsList,statistic=gaResult$statistic));
}
