crowdingDistanceAssignment <-
function(fitnessMatrix) {
	setSize<-nrow(fitnessMatrix);
	if(setSize>=3) {
		fitnessCount<-ncol(fitnessMatrix);
		crowdingDistance<-rep(0,setSize);
		
		for(i in 1:ncol(fitnessMatrix)) {
			fitnessVector<-fitnessMatrix[,i];
			ord<-order(fitnessVector);
			fitnessVector<-fitnessVector[ord];
			
			tmpCrowdingDistance<-rep(0,setSize);
			tmpCrowdingDistance[ord[c(1,setSize)]]<-Inf;
			tmpCrowdingDistance[ord[2:(setSize-1)]]<-
					tmpCrowdingDistance[ord[2:(setSize-1)]]+abs(fitnessVector[1:(setSize-2)]-fitnessVector[2:(setSize-1)]);
			tmpCrowdingDistance[ord[2:(setSize-1)]]<-
					tmpCrowdingDistance[ord[2:(setSize-1)]]+abs(fitnessVector[3:setSize]-fitnessVector[2:(setSize-1)]);
			
			crowdingDistance<-crowdingDistance+tmpCrowdingDistance;
		}
	}
	else {
		crowdingDistance<-rep(Inf,setSize);
	}
	
	return(crowdingDistance);
}
