applyMultiobjectiveFitness <-
function(population,multiobjectiveFitness,fitnessParameters,...) {
	popSize<-length(population);
	
	fitnessVector<-numeric();
	
	for(i in 1:popSize) {
		fitnessVectorTmp<-do.call(multiobjectiveFitness,c(list(chromosome=population[[i]]),fitnessParameters,list(...)));
		fitnessVector<-c(fitnessVector,fitnessVectorTmp);
	}
	fitnessMatrix<-matrix(fitnessVector,nrow=popSize,byrow=TRUE);
	
	return(fitnessMatrix);
}
