multimodalNsga2Algorithm <-
function(initGenome,
		multiobjectiveFitness,crossover,mutation,
		popSize=100,generations=100,
		statisticFunction=FALSE,repair=identity,fitnessParameters=list(),...) {
	statistic<-numeric();
	
	population<-list();
	population<-replicate(popSize,list(initGenome()));
	population<-lapply(population,repair);
	
	fitnessMatrix<-applyMultiobjectiveFitness(population,multiobjectiveFitness,fitnessParameters,...);
	rank<-nonDominatedSorting(fitnessMatrix);
	popSelection<-tournamentSelection(rank);
	selectedPopulation<-population[popSelection];
	ofspringPopulation<-list();
	for(i in 1:(popSize/2)) {
		ind1<-2*(i-1)+1;
		ind2<-2*(i-1)+2;
		offsprings<-crossover(selectedPopulation[[ind1]],selectedPopulation[[ind2]]);
		offsprings[[1]]<-mutation(offsprings[[1]]);
		offsprings[[2]]<-mutation(offsprings[[2]]);
		offsprings[[1]]<-repair(offsprings[[1]]);
		offsprings[[2]]<-repair(offsprings[[2]]);
		ofspringPopulation<-c(ofspringPopulation,offsprings);
	}
	
	for(generation in 1:generations) {
		oldFitnessMatrix<-fitnessMatrix;
		
		fitnessMatrix<-applyMultiobjectiveFitness(ofspringPopulation,multiobjectiveFitness,fitnessParameters,...);
		fitnessMatrix<-rbind(oldFitnessMatrix,fitnessMatrix);
		populationsUnion<-c(population,ofspringPopulation);
		frontNumbers<-nonDominatedSorting(fitnessMatrix);
		
		newPopulationSelection<-logical();
		actualFrontN<-1;
		while((length(newPopulationSelection)<popSize) && (actualFrontN<=max(frontNumbers))) {
			actualFront<-which(frontNumbers==actualFrontN);
			actualFront<-actualFront[!duplicated(populationsUnion[actualFront])];
			if(length(actualFront)+length(newPopulationSelection)<=popSize) {
				frontFitnessMatrix<-fitnessMatrix[actualFront,];
				if(is.vector(frontFitnessMatrix)==TRUE) {
					frontFitnessMatrix<-matrix(frontFitnessMatrix,nrow=1);
				}
				crowdingDistance<-crowdingDistanceAssignment(frontFitnessMatrix);
				ord<-order(crowdingDistance,decreasing=TRUE);
				
				newPopulationSelection<-c(newPopulationSelection,actualFront[ord]);
			}
			else {
				actualFront<-which(frontNumbers==actualFrontN);
				frontFitnessMatrix<-fitnessMatrix[actualFront,];
				dupl<-!duplicated(frontFitnessMatrix);
				
				if(length(newPopulationSelection)+sum(dupl)<=popSize) {
					newPopulationSelection<-c(newPopulationSelection,actualFront[dupl]);
					frontFitnessMatrix<-frontFitnessMatrix[!dupl,];
					if(is.vector(frontFitnessMatrix)) {
						frontFitnessMatrix<-matrix(frontFitnessMatrix,nrow=1);
					}
					actualFront<-actualFront[!dupl];
					
					missing<-popSize-length(newPopulationSelection);
					chosen<-sample(length(actualFront),missing);
					newPopulationSelection<-c(newPopulationSelection,actualFront[chosen]);
				}
				else {
					missing<-popSize-length(newPopulationSelection);
					
					frontFitnessMatrix<-fitnessMatrix[actualFront,];
					if(is.vector(frontFitnessMatrix)==TRUE) {
						frontFitnessMatrix<-matrix(frontFitnessMatrix,nrow=1);
					}
					crowdingDistance<-crowdingDistanceAssignment(frontFitnessMatrix);
					ord<-order(crowdingDistance,decreasing=TRUE);
					newPopulationSelection<-c(newPopulationSelection,actualFront[ord[1:missing]]);
				}
			}
			
			actualFrontN<-actualFrontN+1;
		}
		
		if(length(newPopulationSelection)<length(population)) {
			randomSolutions<-replicate(length(population)-length(newPopulationSelection),list(initGenome()));
			randomSolutions<-lapply(randomSolutions,repair);
			
			population[1:length(newPopulationSelection)]<-populationsUnion[newPopulationSelection];
			population[(length(newPopulationSelection)+1):length(population)]<-randomSolutions;
			
			fitnessMatrix<-fitnessMatrix[newPopulationSelection,];
			if(is.vector(fitnessMatrix)==TRUE) {
				fitnessMatrix<-matrix(fitnessMatrix,nrow=1);
			}
			fitnessMatrixRND<-applyMultiobjectiveFitness(population[(length(newPopulationSelection)+1):length(population)],
					multiobjectiveFitness,fitnessParameters,...);
			if(is.vector(fitnessMatrixRND)==TRUE) {
				fitnessMatrixRND<-matrix(fitnessMatrixRND,nrow=1);
			}
			fitnessMatrix<-rbind(fitnessMatrix,fitnessMatrixRND);
		}
		else {
			population<-populationsUnion[newPopulationSelection];
			fitnessMatrix<-fitnessMatrix[newPopulationSelection,];
		}
		
		popSelection<-tournamentSelectionOrdered(popSize);
		selectedPopulation<-population[popSelection];
		ofspringPopulation<-list();
		for(i in 1:(popSize/2)) {
			ind1<-2*(i-1)+1;
			ind2<-2*(i-1)+2;
			offsprings<-crossover(selectedPopulation[[ind1]],selectedPopulation[[ind2]]);
			offsprings[[1]]<-mutation(offsprings[[1]]);
			offsprings[[2]]<-mutation(offsprings[[2]]);
			offsprings[[1]]<-repair(offsprings[[1]]);
			offsprings[[2]]<-repair(offsprings[[2]]);
			ofspringPopulation<-c(ofspringPopulation,offsprings);
		}
		
		if(class(statisticFunction)=="function") {
			statistic<-statisticFunction(statistic,fitnessMatrix,population);
		}
	}
	
	fitnessMatrix<-applyMultiobjectiveFitness(population,multiobjectiveFitness,fitnessParameters,...);
	frontNumbers<-nonDominatedSorting(fitnessMatrix);
	ord<-order(frontNumbers);
	population<-population[ord];
	fitnessMatrix<-fitnessMatrix[ord,];
	
	return(list(population=population,fitnessMatrix=fitnessMatrix,statistic=statistic));
}
