#include "Rendering\RenderingUnit.h"

CALIB::RenderingUnit::RenderingUnit(int projectorsCount,int projectorsInRow,int projectorImageWidth,int projectorImageHeight,int cameraImageWidth,int cameraImageHeight)
{
	this->count = projectorsCount;
	this->cols = projectorsInRow;
	this->rows = projectorsCount/projectorsInRow;
	this->projectorImageHeight = projectorImageHeight;
	this->projectorImageWidth = projectorImageWidth;
	this->cameraImageWidth = cameraImageWidth;
	this->cameraImageHeight = cameraImageHeight;
	this->displayImageHeight = this->rows * projectorImageHeight;
	this->dispalyImageWidth = this->cols * projectorImageWidth;
}

void CALIB::RenderingUnit::DrawTextureOnMesh(Projector * p,GLuint textureId)
{
	//GL::DrawChackerboard(p->GetMeshRows()-1,p->GetMeshCols()-1,*p->GetPointsMesh());
	this->DrawTextureOnMesh(p->GetMeshRows(),p->GetMeshCols(),textureId,p->GetPointsMesh(),p->GetPointsMeshTexture());
}

void CALIB::RenderingUnit::DrawTextureOnMesh(int meshRows,int meshCols,GLuint textureId,std::vector<geometry::Vector2Df> * meshPoints,std::vector<geometry::Vector2Df> * texturePoints)
{
	//rows = rows -2;
	//cols = cols -2;
//	int rows = meshRows - 1;
//	int cols = meshCols - 1;

	if(meshPoints->empty())
		return;

	//GL::DrawRectangle(0,0,this->projectorImageWidth,this->projectorImageHeight,1.0f);
	GL::DrawTextureOnMesh(&textureId,meshRows,meshCols,meshPoints,texturePoints);
	glColor3f(1.0f,1.0f,1.0f);
}


///**
// * Switch on/off fullscreen mode for camera or projector window.
// */
//void CALIB::RenderingUnit::winSwitchProjFullscreen()
//{
//	if(winProjFullscreen)
//	{
//		glutReshapeWindow(DEF_WIN_WIDTH, DEF_WIN_HEIGHT);
//		glutPositionWindow(DEF_WIN_POS_X,DEF_WIN_POS_Y);
//	}
//	else
//	{
//		glutPositionWindow(projectorWindowPositionX + FULL_WIN_OFFSET_X,projectorWindowPositionY + FULL_WIN_OFFSET_Y);
//		glutReshapeWindow(displayWidth ,displayHeight);
//	}
//	winProjFullscreen = !winProjFullscreen;
//}
//
///**
// * Switch on/off fullscreen mode for camera window
// */
//void CALIB::RenderingUnit::winSwitchCamFullscreen()
//{
//	if(winCamFullscreen)
//	{
//		glutReshapeWindow(DEF_WIN_WIDTH,DEF_WIN_HEIGHT);
//		glutPositionWindow(DEF_WIN_POS_X,DEF_WIN_POS_Y);
//	}
//	else
//	  glutFullScreen();
//	winCamFullscreen = !winCamFullscreen;
//}
