#include "progressindicator.h"
#include "ui_progressindicator.h"

ProgressIndicator::ProgressIndicator(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ProgressIndicator)
{
    ui->setupUi(this);
    hide();
}

ProgressIndicator::~ProgressIndicator()
{
    delete ui;
}

void ProgressIndicator::paintEvent(QPaintEvent *e)
{
    Q_UNUSED(e);
    QPainter painter(this);
    painter.setBrush(QBrush(QColor(0, 0, 0, 222), Qt::BrushStyle::Dense4Pattern));
    painter.setPen(Qt::NoPen);
    painter.drawRect(0, 0, width(), height());
}

void ProgressIndicator::setText(QString text)
{
    ui->label->setText(text);
}
