#include "paramscontroller.h"
#include "ui_paramscontroller.h"

ParamsController::ParamsController(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ParamsController)
{
    ui->setupUi(this);
    on_horizontalSlider_valueChanged(getValue());
}

ParamsController::~ParamsController()
{
    delete ui;
}

double ParamsController::getValue() const
{
    return ((double)ui->horizontalSlider->value())/ui->horizontalSlider->maximum();
}

double ParamsController::getGeometricSubdivisionThresholdValue() const
{
    return 5;
}

double ParamsController::getSimilaritySubdivisionThresholdValue() const
{
    return 1-getValue();
}

double ParamsController::getMinSegmentLengthValue() const
{
    return 5;
}

void ParamsController::on_horizontalSlider_valueChanged(int value)
{
    Q_UNUSED(value);

    double valueDouble = getValue();

    QString valueString;
    valueString.sprintf("%.2f", valueDouble);

    ui->labelSensitivityValue->setText(valueString);
}

void ParamsController::on_horizontalSlider_sliderReleased()
{
    emit paramValueChanged();
}

void ParamsController::keyReleaseEvent(QKeyEvent *e)
{
    Q_UNUSED(e);

    //emit valueChanged();
}
