#ifndef CVVIDEOPLAYER_H
#define CVVIDEOPLAYER_H

#include <QWidget>
#include <QImage>
#include <QDebug>
#include <QResizeEvent>
#include <QImage>
#include <opencv2/opencv.hpp>


namespace Ui {
class CvVideoPlayer;
}

class CvVideoPlayer : public QWidget
{
    Q_OBJECT

public:
    explicit CvVideoPlayer(QWidget *parent = 0);
    ~CvVideoPlayer();
    void open(QString filename);
    void close();
    int getPosition() const;
    bool setPosition(int frame);
    bool next();
    
private:
    Ui::CvVideoPlayer *ui;
    QImage frame;
    cv::VideoCapture *capture;

    void readImage();
    QImage matToQimage(cv::Mat & src);

    void resizeEvent(QResizeEvent *e);
};

#endif // CVVIDEOPLAYER_H
