#include "VideoMatcher.h"


namespace vmatch {


VideoMatcher::VideoMatcher(VideoSequenceDataSource::Config config) {
	this->dataSource = VideoSequenceDataSource::create(config);
}


VideoMatcher::VideoMatcher(VideoSequenceDataSourcePtr dataSource) {
	CV_Assert(dataSource != NULL);
	this->dataSource = dataSource;
}


Segments VideoMatcher::match(const std::string & ref, const std::string & query) {
	CV_Assert(ref != "");
	CV_Assert(query != "");

	VideoSequenceDataPtr dataRef = dataSource->getSequenceData(ref);
	VideoSequenceDataPtr dataQry = dataSource->getSequenceData(query);

	BruteForceVideoComparer videoComparer;
	NeedlemanWunschSegmentsExtractor segmentsExtractor;

	vmatch::SimilarityMatrix similarityMatrix = videoComparer.compare(dataRef->getKeyFrames(), dataQry->getKeyFrames());
	Segments segments = segmentsExtractor.extract(similarityMatrix, dataRef, dataQry);

	return segments;
}


}
