#pragma once

#include <opencv2/features2d/features2d.hpp>
#include <vector>
#include <iostream>

using namespace std;
using namespace cv;

namespace Motion {


class Track {
private:
	typedef vector<KeyPoint> Trajectory;

	Trajectory trajectory;
	Mat descriptor;	
	int64 firstTimestamp;
	int64 lastTimestamp;
	int matched;
	unsigned int lastUpdateBefore;
	
	Mat ftfDescriptor;
	float ftfNcc;
	bool ftfNccUpdated;
	int ftfUpdatedBefore;
	int reassignId;
	int reassignCount;

public:
	Track(const KeyPoint & keypoint, const Mat & descriptor, int64 timestamp);
	void update(const KeyPoint & keypoint, const Mat & descriptor, int64 timestamp = -1);
	void update(const Track & track);
	unsigned int getLength() const;
	const KeyPoint & getKeypoint(unsigned int before = 0) const;
	const Mat & getDescriptor() const;
	int64 getFirstTimeStamp() const;
	int64 getLastTimeStamp() const;
	unsigned int getUpdatedBefore() const;
	void setUpdatedBefore(unsigned int ub);
	void propagate(Point2f pos);
	void propagate();
	float distancePosition(const Track & second) const;
	int distanceDescriptorHamming(const Track & second) const;
	float distanceDescriptorEuclidean(const Track & second) const;
	float ncc(const Point2f & point, const Mat & thisGray, const Mat & secondGray) const;
	float ncc(const Track & second, const Mat & thisGray, const Mat & secondGray) const;
	bool operator>(const Track & second) const;

friend class TrackContainer;
friend class TrackMatcher;
friend class TrackRepairer;
friend class ObjectExtractor;
};


typedef Ptr<Track> TrackPtr;
}