#pragma once

#include <opencv2/features2d/features2d.hpp>

using namespace std;
using namespace cv;

namespace Motion {


typedef Ptr<FeatureDetector> FeatureDetectorPtr;
typedef Ptr<DescriptorExtractor> DescriptorExtractorPtr;
typedef vector<KeyPoint> KeyPoints;


class NoneDescriptorExtractor : public DescriptorExtractor {
public:	
	void read(const FileNode & fn);
    void write(FileStorage & fs) const;
	int descriptorSize() const;
    int descriptorType() const;
	virtual void computeImpl(const Mat & image, KeyPoints & keypoints, Mat & descriptors) const;
};


}
