#include "FrameDescriptor.h"


namespace vmatch {


FrameDescriptor::FrameDescriptor(int type) {
	this->type = type;
}


int FrameDescriptor::getType() const {
	return type;
}


bool FrameDescriptor::isVector() const {
	return false;
}


const cv::Mat & FrameDescriptor::getVector() const {
	return cv::Mat();
}


const std::string VectorFrameDescriptor::NODE_VECTOR = "v";


VectorFrameDescriptor::VectorFrameDescriptor(int type, cv::Mat data) : FrameDescriptor(type) {
	CV_Assert(!data.empty());
	this->data = data;
}


double VectorFrameDescriptor::compare(const FrameDescriptor & second) const {
	CV_Assert(!data.empty());
	CV_Assert(!second.getVector().empty());
	
	if(!second.isVector()) {
		CV_Error(CV_StsBadArg, "Only two VectorFrameDescriptors can be compared with this method.");
		return 0;
	}

	uchar *firstPtr = (uchar *)data.data;
	uchar *secondPtr = (uchar *)second.getVector().data;
	
	CV_Assert(firstPtr != NULL);
	CV_Assert(secondPtr != NULL);

	double distance = 0;
	for(int i = 0; i < data.cols; i++) {
		distance += (firstPtr[i] - secondPtr[i]) * (firstPtr[i] - secondPtr[i]);
	}

	CV_Assert(distance >= 0);

	return sqrt(distance);
}


bool VectorFrameDescriptor::isVector() const {
	return true;
}


const cv::Mat & VectorFrameDescriptor::getVector() const {
	CV_Assert(!data.empty());
	return data;
}


void VectorFrameDescriptor::read(cv::FileNode & nd) {
	CV_Assert(!nd.empty());
	CV_Assert(!nd[NODE_VECTOR].empty() || !nd["vector"].empty());
	
	if(!nd[NODE_VECTOR].empty()) {
		nd[NODE_VECTOR] >> data;
	}
	else if(!nd["vector"].empty()) {
		nd["vector"] >> data;
	}
}


void VectorFrameDescriptor::write(cv::FileStorage & fs) const {
	fs << NODE_VECTOR << data;
}


}
