grammar Lfd;

file
    :    (func)+
    ;


func
    :    ID '(' ')' block
    ;


block
    :    '{' statement* '}'
    ;


statement
    :    func_call ';'
    |    loop_stmt
    ;


func_call
    :    ID arguments
    ;
    
loop_stmt
    :    'LOOP' block
    ;


arguments
    :    '(' argumentList? ')'
    ;

argumentList
    :    argument (',' argument)*
    ;

argument
    :   DecimalLiteral
    |   FloatingPointLiteral
    |   CharacterLiteral
    |   StringLiteral
    |   booleanLiteral
    |   func_call
    |   'NULL'
    ;

booleanLiteral
    :   'true'
    |   'false'
    ;

// Lex part, symbols start with big letter


DecimalLiteral : ('0' | '-'* '1'..'9' '0'..'9'*);

FloatingPointLiteral
    :    ('0'..'9')+ '.' ('0'..'9')* Exponent?
    |    '.' ('0'..'9')+ Exponent?
    |    ('0'..'9')+ Exponent
    |    ('0'..'9')+
    |    ('0x' | '0X') (HexDigit )*
         ('.' (HexDigit)*)?
         ( 'p' | 'P' )
         ( '+' | '-' )?
         ( '0' .. '9' )+
    ;

fragment
Exponent : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;

fragment
HexDigit : ('0'..'9'|'a'..'f'|'A'..'F') ;


CharacterLiteral
    :    '\'' ( EscapeSequence | ~('\''|'\\') ) '\''
    ;

StringLiteral
    :    '"' ( EscapeSequence | ~('\\'|'"') )* '"'
    ;

fragment
EscapeSequence
    :    '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\')
    |    UnicodeEscape
    ;

fragment
UnicodeEscape
    :   '\\' 'u' HexDigit HexDigit HexDigit HexDigit
    ;


ID
    :    [_a-zA-Z][_a-zA-Z0-9]+
    ;


WS  
    :    [ \r\t\u000C\n]+	-> skip
    ;

LINE_COMMENT
    :    '#' .*? '\r'? '\n'	-> skip
    ;

