
/***
 * Lfd comparator
 * Author: Lukas Durfina, idurfina@fit.vutbr.cz
 ***/

package comparators;


import java.util.*;
import main.*;

public class StatementParentComparator implements IComparator {

	public StatementParentComparator() {
	}
	
	
	/**
	 * Index to statements of A  
	 */
	private int _indexA = 0;
	
	/**
	 * Number of elements in A
	 */
	private int _countA = 0;
	
	/**
	 * Index to statements of B  
	 */
	private int _indexB = 0;
	
	/**
	 * Number of elements in B
	 */
	private int _countB = 0;

	
	
	private boolean _lastShakedA = false;
	
	/**
	 * Factor of similarity, when we are changing the original order,
	 * we decrease the similarity
	 */
	private double _similarityFactor = 1.0;
	
	
	public double compare(IComparable a, IComparable b) {
		
		if (a instanceof IStatementParent && b instanceof IStatementParent) {
			
			IStatementParent spA = (IStatementParent) a;
			IStatementParent spB = (IStatementParent) b;
			
			LfdComparator.debug("Comparing statement parents");
			
			double totalSim = 0.0;
			
			Vector<IStatement> stmtsA = spA.getStatements();
			Vector<IStatement> stmtsB = spB.getStatements();
			
			_countA = stmtsA.size();
			_countB = stmtsB.size();
			
			LfdComparator.debug("Statements count: " + _countA + " - " + _countB);
			
			int stmtMax = Math.max(_countA, _countB);
			
			if (stmtMax > 0) {
				double simPart = 100.0 / stmtMax;

				_indexA = 0;
				_indexB = 0;
				while (_indexA < _countA && _indexB < _countB) {
					IStatement stmtA = stmtsA.elementAt(_indexA);
					IStatement stmtB = stmtsB.elementAt(_indexB);

					double sim = 0;

					if (stmtA instanceof LfdFunctionCall && stmtB instanceof LfdFunctionCall) {
						LfdFunctionCallComparator cmp = new LfdFunctionCallComparator();
						sim = cmp.compare(stmtA, stmtB);
						totalSim += _similarityFactor * simPart * (sim / 100.0);
						goToNextStatements();
					}
					else if (stmtA instanceof Loop && stmtB instanceof Loop) {
						LoopComparator cmp = new LoopComparator();
						sim = cmp.compare(stmtA, stmtB);
						totalSim += _similarityFactor * simPart * (sim / 100.0);
						goToNextStatements();
					}
					else {
						// they are not same -> try lightly change the order 
						// and decrease factor of similarity
						LfdComparator.debug("Not handled combination of statements");
						shakeStatementsOrder();
					}
				}
			}
			else {
				// no called function, so we take them as equal
				// we cannot compare names, because i.e. in stripped binaries it will
				// always differ and they were same functions before
				totalSim = 100;
			}
			
			LfdComparator.debug("totalSim: " + totalSim);
			
			return totalSim;
		}
		
		LfdComparator.error("Some item to compare is not a function");
		
		return 0;
	}
	
	
	/**
	 * Move to next pair of statements
	 */
	private void goToNextStatements() {
		_indexA++;
		_indexB++;
		_similarityFactor = 1.0;
	}
	
	
	/**
	 * Update indexes of compared statements in not standard way, because
	 * there is something wrong
	 */
	private void shakeStatementsOrder() {
		int diffA = _countA - _indexA;
		int diffB = _countB - _indexB;
		if (diffA > diffB) {
			_indexA++;
		}
		else if (diffB > diffA) {
			_indexB++;
		}
		else {
			// same increase the opposite to last time
			if (_lastShakedA) {
				_indexB++;
			}
			else {
				_indexA++;
			}

		}
		
		_similarityFactor -= 0.33;
		if (_similarityFactor < 0.1) {
			_similarityFactor = 0.1;
		}
	}
	
}
