
/***
 * Lfd comparator
 * Author: Lukas Durfina, idurfina@fit.vutbr.cz
 ***/

package comparators;


import java.util.Vector;

import main.LfdComparator;
import main.LfdFunctionCall;

public class LfdFunctionCallComparator implements IComparator {

	public LfdFunctionCallComparator() {
	}
	
	public double compare(IComparable a, IComparable b) {
		
		if (a instanceof LfdFunctionCall && b instanceof LfdFunctionCall) {
			
			LfdFunctionCall callA = (LfdFunctionCall) a;
			LfdFunctionCall callB = (LfdFunctionCall) b;
			
			LfdComparator.debug("Comparing funcion calls: ");
			
			double argumentFactor = 1.0;
			
			// according to similarity of arguments, we increase or decrease final similarity
			Vector<String> argsA = callA.getArguments();
			Vector<String> argsB = callB.getArguments();
			
			int argCountA = argsA.size();
			int argCountB = argsB.size();
			
			if (argCountA == argCountB) {
				for (int i = 0; i  < argCountA; i++) {
					String argA = argsA.elementAt(i);
					String argB = argsB.elementAt(i);
					
					if (argA.equals(argB)) {
						// same -> REWARD
						argumentFactor *= 1.05;
					}
					else {
						// different -> LOSS
						argumentFactor *= 0.75;
					}
				}
			}
			else {
				// counter of argument is different -> LOSS
				argumentFactor *= 0.8;
			}
			
			LfdFunctionComparator funcComparator = new LfdFunctionComparator();
			return argumentFactor * funcComparator.compare(callA.getCalledFunction(), callB.getCalledFunction());
		}
		
		LfdComparator.error("Some item to compare is not a function call");
		
		return 0;
	}
	
}
