#ifndef _BIL_FIL_FAST_H_
#define _BIL_FIL_FAST_H_

#include "universalbmp.h"

typedef   TUniversalBmpFloat       TFloatBmp;

//-----------------------------------------------------------------------------

class FastBilateralFilter
{
  public:

  // parameters

  // Radius, both are summed, the other set to 0
  float RadiusFrac;       // Fraction of longer side, eg 0.15
  int   RadiusPixels;     // Pixels

    // Radius of intensity, where function drops below.... 0.1?
    // Radius, both are summed, the other set to 0
  float IntensityRadiusFrac; // Fraction of histogram Min to Max
  float IntensityRadius;     // Absolute value

  void ComputeBilateralPrecompile(TFloatBmp &InIntensity, bool TripleEMA = false);
  void ComputeBilateralFinish(TFloatBmp &InIntensity, bool Lanczos = false);
  void ComputeBilateralFreeMem();

  TFloatBmp FilterOutput;

  protected:
    void ComputeRadius();
    void ComputeIntensityRadius();
    inline float IntensityWeight(float Dif);
    int MaxHistogram;
    float HistogramAddItemsToSide; // histogram extra items on both sides for bluring
    int FastBilateralSquareSize;
    int MaxX,MaxY;
    int ComputedRadius;
    float MinInputIntensity;
    float MaxInputIntensity;
    float InvInputDynamicRange;
    float DynRangeToHistogIndex;
    int HistogramSize;
    float ComputedIntensityRadius;
    float ComputedIntensityRadiusFrac;
    float InvComputedIntensityRadius;
    TFloatBmp IntensityHistograms;
    TFloatBmp IntMultIntHistograms;
};

extern const float BlurFloatsSideWeightDefault;
extern float BlurFloatsSideWeight;

#endif
