/*
								+--------------------------------+
								|                                |
								|  ***   OpenGL ES shader   ***  |
								|                                |
								|  Copyright  -tHE SWINe- 2013  |
								|                                |
								|           Shader.inl           |
								|                                |
								+--------------------------------+
*/

#pragma once
#ifndef __GLES20_SHADER_SHADER_INCLUDED
#define __GLES20_SHADER_SHADER_INCLUDED

/**
 *	@file gles2/Shader.inl
 *	@author -tHE SWINe-
 *	@date 2013
 *	@brief OpenGL ES 2.0 shaders
 */

/*
 *								=== CGLESShader ===
 */

inline bool CGLESShader::b_Initialized() const
{
	_ASSERTE(!m_n_program_object || glIsProgram(m_n_program_object));
	return m_n_program_object != 0;
}

inline bool CGLESShader::b_Compiled() const
{
#ifdef __GLES20SHADER_HOLD_STATUS_INFO
	return m_b_compiled;
#else // __GLES20SHADER_HOLD_STATUS_INFO
	if(!b_Initialized())
		return false;

	std::vector<GLuint> shader_list;
	if(!Get_ShaderList(shader_list))
		return false; // what do i do?
	// get shader list

	for(size_t i = 0, n = shader_list.size(); i < n; ++ i) {
		int n_compile_status;
		glGetShaderiv(shader_list[i], GL_COMPILE_STATUS, &n_compile_status);
		if(n_compile_status != GL_TRUE)
			return false;
	}
	// get shaders for a program and check if they all compiled

	return true;
#endif // __GLES20SHADER_HOLD_STATUS_INFO
}

inline bool CGLESShader::b_Linked() const
{
#ifdef __GLES20SHADER_HOLD_STATUS_INFO
	return m_b_linked;
#else // __GLES20SHADER_HOLD_STATUS_INFO
	if(!b_Initialized())
		return false;
	int n_tmp;
	glGetProgramiv(m_n_program_object, GL_LINK_STATUS, &n_tmp);
	return n_tmp == GL_TRUE;
#endif // __GLES20SHADER_HOLD_STATUS_INFO
}

inline void CGLESShader::Bind() const
{
	glUseProgram(m_n_program_object);
}

inline void CGLESShader::Release()
{
	glUseProgram(0);
}

#if 0 // not (yet) in OpenGL ES 2.0
inline void CGLESShader::Bind(GLuint n_pipeline, GLbitfield n_stages)
{
	_ASSERTE(GLEH_ARB_separate_shader_objects);
	glUseProgramStages(n_pipeline, n_stages, m_n_program_object);
}

inline void CGLESShader::Release(GLuint n_pipeline, GLbitfield n_stages)
{
	_ASSERTE(GLEH_ARB_separate_shader_objects);
	glUseProgramStages(n_pipeline, n_stages, 0);
}

inline void CGLESShader::MakeActive(GLuint n_pipeline)
{
	_ASSERTE(GLEH_ARB_separate_shader_objects);
	glActiveShaderProgram(n_pipeline, m_n_program_object);
}
#endif // 0

inline void CGLESShader::Uniform1f(int n_location, float f_v0) const
{
	glUniform1f(n_location, f_v0);
}

inline void CGLESShader::Uniform2f(int n_location, float f_v0, float f_v1) const
{
	glUniform2f(n_location, f_v0, f_v1);
}

inline void CGLESShader::Uniform3f(int n_location, float f_v0, float f_v1, float f_v2) const
{
	glUniform3f(n_location, f_v0, f_v1, f_v2);
}

inline void CGLESShader::Uniform4f(int n_location, float f_v0, float f_v1, float f_v2, float f_v3) const
{
	glUniform4f(n_location, f_v0, f_v1, f_v2, f_v3);
}

inline void CGLESShader::Uniform1fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glUniform1fv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform2fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glUniform2fv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform3fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glUniform3fv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform4fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glUniform4fv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform1i(int n_location, int n_v0) const
{
	glUniform1i(n_location, n_v0);
}

inline void CGLESShader::Uniform2i(int n_location, int n_v0, int n_v1) const
{
	glUniform2i(n_location, n_v0, n_v1);
}

inline void CGLESShader::Uniform3i(int n_location, int n_v0, int n_v1, int n_v2) const
{
	glUniform3i(n_location, n_v0, n_v1, n_v2);
}

inline void CGLESShader::Uniform4i(int n_location, int n_v0, int n_v1, int n_v2, int n_v3) const
{
	glUniform4i(n_location, n_v0, n_v1, n_v2, n_v3);
}

inline void CGLESShader::Uniform1iv(int n_location, int n_count, const GLint *p_value) const
{
	glUniform1iv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform2iv(int n_location, int n_count, const GLint *p_value) const
{
	glUniform2iv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform3iv(int n_location, int n_count, const GLint *p_value) const
{
	glUniform3iv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform4iv(int n_location, int n_count, const GLint *p_value) const
{
	glUniform4iv(n_location, n_count, p_value);
}

inline void CGLESShader::UniformMatrix2fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix2fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix3fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix3fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix4fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix4fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

#if 0 // not (yet) in OpenGL ES 2.0
inline void CGLESShader::UniformMatrix2x3fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix2x3fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix3x2fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix3x2fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix2x4fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix2x4fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix4x2fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix4x2fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix3x4fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix3x4fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix4x3fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glUniformMatrix4x3fv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}
#endif // 0

#if 0 // not (yet) in OpenGL ES 2.0
inline void CGLESShader::Uniform1ui(int n_location, unsigned int n_v0) const
{
	glUniform1ui(n_location, n_v0);
}

inline void CGLESShader::Uniform2ui(int n_location, unsigned int n_v0, unsigned int n_v1) const
{
	glUniform2ui(n_location, n_v0, n_v1);
}

inline void CGLESShader::Uniform3ui(int n_location, unsigned int n_v0, unsigned int n_v1, unsigned int n_v2) const
{
	glUniform3ui(n_location, n_v0, n_v1, n_v2);
}

inline void CGLESShader::Uniform4ui(int n_location, unsigned int n_v0, unsigned int n_v1, unsigned int n_v2, unsigned int n_v3) const
{
	glUniform4ui(n_location, n_v0, n_v1, n_v2, n_v3);
}

inline void CGLESShader::Uniform1uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glUniform1uiv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform2uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glUniform2uiv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform3uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glUniform3uiv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform4uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glUniform4uiv(n_location, n_count, p_value);
}
#endif // 0

#if 0 // not (yet) in OpenGL ES 2.0
inline void CGLESShader::Uniform1d(int n_location, double f_v0) const
{
	glUniform1d(n_location, f_v0);
}

inline void CGLESShader::Uniform2d(int n_location, double f_v0, double f_v1) const
{
	glUniform2d(n_location, f_v0, f_v1);
}

inline void CGLESShader::Uniform3d(int n_location, double f_v0, double f_v1, double f_v2) const
{
	glUniform3d(n_location, f_v0, f_v1, f_v2);
}

inline void CGLESShader::Uniform4d(int n_location, double f_v0, double f_v1, double f_v2, double f_v3) const
{
	glUniform4d(n_location, f_v0, f_v1, f_v2, f_v3);
}

inline void CGLESShader::Uniform1dv(int n_location, int n_count, const double *p_value) const
{
	glUniform1dv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform2dv(int n_location, int n_count, const double *p_value) const
{
	glUniform2dv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform3dv(int n_location, int n_count, const double *p_value) const
{
	glUniform3dv(n_location, n_count, p_value);
}

inline void CGLESShader::Uniform4dv(int n_location, int n_count, const double *p_value) const
{
	glUniform4dv(n_location, n_count, p_value);
}

inline void CGLESShader::UniformMatrix2dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix2dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix3dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix3dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix4dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix4dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix2x3dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix2x3dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix3x2dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix3x2dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix2x4dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix2x4dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix4x2dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix4x2dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix3x4dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix3x4dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::UniformMatrix4x3dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glUniformMatrix4x3dv(n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}
#endif // 0

#if 0 // not (yet) in OpenGL ES 2.0
inline void CGLESShader::ProgramUniform1f(int n_location, float f_v0) const
{
	glProgramUniform1f(m_n_program_object, n_location, f_v0);
}

inline void CGLESShader::ProgramUniform2f(int n_location, float f_v0, float f_v1) const
{
	glProgramUniform2f(m_n_program_object, n_location, f_v0, f_v1);
}

inline void CGLESShader::ProgramUniform3f(int n_location, float f_v0, float f_v1, float f_v2) const
{
	glProgramUniform3f(m_n_program_object, n_location, f_v0, f_v1, f_v2);
}

inline void CGLESShader::ProgramUniform4f(int n_location, float f_v0, float f_v1, float f_v2, float f_v3) const
{
	glProgramUniform4f(m_n_program_object, n_location, f_v0, f_v1, f_v2, f_v3);
}

inline void CGLESShader::ProgramUniform1i(int n_location, int n_v0) const
{
	glProgramUniform1i(m_n_program_object, n_location, n_v0);
}

inline void CGLESShader::ProgramUniform2i(int n_location, int n_v0, int n_v1) const
{
	glProgramUniform2i(m_n_program_object, n_location, n_v0, n_v1);
}

inline void CGLESShader::ProgramUniform3i(int n_location, int n_v0, int n_v1, int n_v2) const
{
	glProgramUniform3i(m_n_program_object, n_location, n_v0, n_v1, n_v2);
}

inline void CGLESShader::ProgramUniform4i(int n_location, int n_v0, int n_v1, int n_v2, int n_v3) const
{
	glProgramUniform4i(m_n_program_object, n_location, n_v0, n_v1, n_v2, n_v3);
}

inline void CGLESShader::ProgramUniform1ui(int n_location, unsigned int n_v0) const
{
	glProgramUniform1ui(m_n_program_object, n_location, n_v0);
}

inline void CGLESShader::ProgramUniform2ui(int n_location, unsigned int n_v0, unsigned int n_v1) const
{
	glProgramUniform2ui(m_n_program_object, n_location, n_v0, n_v1);
}

inline void CGLESShader::ProgramUniform3ui(int n_location, unsigned int n_v0, unsigned int n_v1, unsigned int n_v2) const
{
	glProgramUniform3ui(m_n_program_object, n_location, n_v0, n_v1, n_v2);
}

inline void CGLESShader::ProgramUniform4ui(int n_location, unsigned int n_v0, unsigned int n_v1, unsigned int n_v2, unsigned int n_v3) const
{
	glProgramUniform4ui(m_n_program_object, n_location, n_v0, n_v1, n_v2, n_v3);
}

inline void CGLESShader::ProgramUniform1d(int n_location, double f_v0) const
{
	glProgramUniform1d(m_n_program_object, n_location, f_v0);
}

inline void CGLESShader::ProgramUniform2d(int n_location, double f_v0, double f_v1) const
{
	glProgramUniform2d(m_n_program_object, n_location, f_v0, f_v1);
}

inline void CGLESShader::ProgramUniform3d(int n_location, double f_v0, double f_v1, double f_v2) const
{
	glProgramUniform3d(m_n_program_object, n_location, f_v0, f_v1, f_v2);
}

inline void CGLESShader::ProgramUniform4d(int n_location, double f_v0, double f_v1, double f_v2, double f_v3) const
{
	glProgramUniform4d(m_n_program_object, n_location, f_v0, f_v1, f_v2, f_v3);
}

inline void CGLESShader::ProgramUniform1fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glProgramUniform1fv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform2fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glProgramUniform2fv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform3fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glProgramUniform3fv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform4fv(int n_location, int n_count, const GLfloat *p_value) const
{
	glProgramUniform4fv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform1iv(int n_location, int n_count, const GLint *p_value) const
{
	glProgramUniform1iv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform2iv(int n_location, int n_count, const GLint *p_value) const
{
	glProgramUniform2iv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform3iv(int n_location, int n_count, const GLint *p_value) const
{
	glProgramUniform3iv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform4iv(int n_location, int n_count, const GLint *p_value) const
{
	glProgramUniform4iv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform1uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glProgramUniform1uiv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform2uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glProgramUniform2uiv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform3uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glProgramUniform3uiv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform4uiv(int n_location, int n_count, const GLuint *p_value) const
{
	glProgramUniform4uiv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform1dv(int n_location, int n_count, const double *p_value) const
{
	glProgramUniform1dv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform2dv(int n_location, int n_count, const double *p_value) const
{
	glProgramUniform2dv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform3dv(int n_location, int n_count, const double *p_value) const
{
	glProgramUniform3dv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniform4dv(int n_location, int n_count, const double *p_value) const
{
	glProgramUniform4dv(m_n_program_object, n_location, n_count, p_value);
}

inline void CGLESShader::ProgramUniformMatrix2fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix2fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix3fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix3fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix4fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix4fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix2dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix2dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix3dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix3dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix4dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix4dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix2x3fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix2x3fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix3x2fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix3x2fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix2x4fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix2x4fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix4x2fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix4x2fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix3x4fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix3x4fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix4x3fv(int n_location, int n_count, bool b_transpose, const GLfloat *p_value) const
{
	glProgramUniformMatrix4x3fv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix2x3dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix2x3dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix3x2dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix3x2dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix2x4dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix2x4dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix4x2dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix4x2dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix3x4dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix3x4dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}

inline void CGLESShader::ProgramUniformMatrix4x3dv(int n_location, int n_count, bool b_transpose, const double *p_value) const
{
	glProgramUniformMatrix4x3dv(m_n_program_object, n_location, n_count, (b_transpose)? GL_TRUE : GL_FALSE, p_value);
}
#endif // 0

/*
 *								=== ~CGLESShader ===
 */

#endif // __GLES20_SHADER_SHADER_INCLUDED
