#!/usr/bin/python

import dpkt
import argparse
import sys
import datetime
import os
import commands
import string
import psycopg2
import select

PREFIX="\n\t\t\t\t"
PCAP_PATH="/var/log/aips/pcap/"
DB_HOST="localhost"
DB_USER="postgres"
DB_PASSWD="FRe6Usw8"
DB_TABLE="tcpdump"
ROTATE_INT=300

class DBWorker:
    """
    Class for DB handling and data insertion to PSQL DB
    """
    # database connection
    conn = None

    def __init__(self, db):
        self.db = db

    def __del__(self):
        """
        Destructor closes open database connection
        """
        if self.conn != None:
            conn.close()

    def connect2DB(self):
        """
        Create connection to MySQL db with
        specified parametres
        """
        global conn
        conn = None
        try:
            conn_string = "host="+DB_HOST+" dbname="+self.db+" user="+DB_USER+" password="+DB_PASSWD
            conn = psycopg2.connect(conn_string)
        except psycopg2.Error, e:
            print "PosgreSQL Error %s" % (e,)
            print "PosgreSQL Error %d: %s" % (e.args[0], e.args[1])
            sys.exit (1)

    def listen(self, walk):
        conn.set_isolation_level(0)
        curs = conn.cursor()
        curs.execute("listen tcpdump")
        while 1:
            if select.select([conn],[],[],5)==([],[],[]):
                #print "Timeout"
                pass
            else:
                conn.poll()
                while conn.notifies:
                    notify = conn.notifies.pop()
                    if notify.channel != "tcpdump":
                        print >>sys.stderr, "[E] Unknown notify signal: %s" % (notify.channel,)
                        continue
                    timestamp, incident = notify.payload.split(":")
                    walk(timestamp, int(incident))

    def eth(self, incident, timestamp, size, eth_src, eth_dst, data):
        try:
            cursor = conn.cursor()
            cursor.execute("""
                INSERT INTO %s (id_incident, timestamp, size, type, eth_src, eth_dst, data)
                VALUES (%d, %s, %s, 'ETH', '%s', '%s', '%s');
            """ % (DB_TABLE, incident, timestamp, size, eth_src, eth_dst, data)
            )
            cursor.close()
        except psycopg2.Error, e:
            #print "PostgreSQL Error %d: %s" % (e.args[0], e.args[1])
            print "INSERT ETH: PostgreSQL Error: %s" % (e,)
            sys.exit (1)

        conn.commit()

    def arp(self, incident, timestamp, size, eth_src, eth_dst, hrd, pro, hln, pln, op, sha, spa, tha, tpa):
        try:
            cursor = conn.cursor()
            cursor.execute("""
                INSERT INTO %s (id_incident, timestamp, size, type, eth_src, eth_dst, arp_hrd, arp_pro, arp_hln, arp_pln,
                    arp_op, arp_sha, arp_spa, arp_tha, arp_tpa )
                VALUES (%d, %s, %s, 'ARP', '%s', '%s', %s, %s, %s, %s, %s, '%s', '%s', '%s', '%s');
            """ % (DB_TABLE, incident, timestamp, size, eth_src, eth_dst, hrd, pro, hln, pln, op, sha, spa, tha, tpa)
            )
            cursor.close()
        except psycopg2.Error, e:
            #print "PostgreSQL Error %d: %s" % (e.args[0], e.args[1])
            print "INSERT ARP: PostgreSQL Error: %s" % (e,)
            sys.exit (1)

        conn.commit()

    def igmp(self, incident, timestamp, size, eth_src, eth_dst, sum, type, maxresp, group, v_hl, tos, len, id, off, ttl, p, ip_sum,
            src, dst, data):
        try:
            cursor = conn.cursor()
            cursor.execute("""
                INSERT INTO %s (id_incident, timestamp, size, type, eth_src, eth_dst, sum, igmp_type, igmp_maxresp, igmp_group, ip_v_hl,
                    ip_tos, ip_len, ip_id, ip_off, ip_ttl, ip_p, ip_sum, ip_src, ip_dst, data)
                VALUES (%d, %s, %s, 'IGMP', '%s', '%s', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, '%s', '%s', '%s');
            """ % (DB_TABLE, incident, timestamp, size, eth_src, eth_dst, sum, type, maxresp, group, v_hl, tos, len, id, off, ttl, p, ip_sum,
                src, dst, data)
            )
            cursor.close()
        except psycopg2.Error, e:
            #print "PostgreSQL Error %d: %s" % (e.args[0], e.args[1])
            print "INSERT IGMP: PostgreSQL Error: %s" % (e,)
            sys.exit (1)
        
        conn.commit()

    def tcp(self, incident, timestamp, size, eth_src, eth_dst, sum, sport, dport, seq, ack, off_x2, flags, win, urp, 
            v_hl, tos, len, id, off, ttl, p, ip_sum, src, dst, data):
        try:
            cursor = conn.cursor()
            cursor.execute("""
                INSERT INTO %s (id_incident, timestamp, size, type, eth_src, eth_dst, sum, sport, dport, tcp_seq, tcp_ack, tcp_off_x2,
                    tcp_flags, tcp_win, tcp_urp, ip_v_hl, ip_tos, ip_len, ip_id, ip_off, ip_ttl, ip_p, ip_sum,
                    ip_src, ip_dst, data)
                VALUES (%d, %s, %s, 'TCP', '%s', '%s', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s,
                    %s, '%s', '%s', '%s');
            """ % (DB_TABLE, incident, timestamp, size, eth_src, eth_dst, sum, sport, dport, seq, ack, off_x2, flags, win, urp, v_hl, tos, len, id,
                off, ttl, p, ip_sum, src, dst, data)
            )
            cursor.close()
        except psycopg2.Error, e:
            #print "PostgreSQL Error %d: %s" % (e.args[0], e.args[1])
            print "INSERT TCP: PostgreSQL Error: %s" % (e,)
            sys.exit (1)

        conn.commit()

    def udp(self, incident, timestamp, size, eth_src, eth_dst, sum, sport, dport, v_hl, tos, len, id, off, ttl, p, ip_sum,
            src, dst, data):
        try:
            cursor = conn.cursor()
            cursor.execute("""
                INSERT INTO %s (id_incident, timestamp, size, type, eth_src, eth_dst, sum, sport, dport, ip_v_hl, ip_tos, ip_len, ip_id,
                    ip_off, ip_ttl, ip_p, ip_sum, ip_src, ip_dst, data)
                VALUES (%d, %s, %s, 'UDP', '%s', '%s', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, '%s', '%s', '%s');
            """ % (DB_TABLE, incident, timestamp, size, eth_src, eth_dst, sum, sport, dport, v_hl, tos, len, id, off, ttl, p, ip_sum, src, dst, data)
            )
            cursor.close()
        except psycopg2.Error, e:
            #print "PostgreSQL Error %d: %s" % (e.args[0], e.args[1])
            print "INSERT UDP: PostgreSQL Error: %s" % (e,)
            sys.exit (1)

        conn.commit()


class TCPDumpWalker(object):

    def __init__(self, db=None, tth=None):
        self.db = db
        self.tth = tth

    def tohw(self, s):
        seq = s.encode("hex").upper()
        return  ":".join([seq[i:i+2] for i in range(0, len(seq), 2)])

    def toip(self, s):
        seq = s.encode("hex").upper()
        return  ".".join([`int(seq[i:i+2], 16)` for i in range(0, len(seq), 2)])

    def tohex(self, s):
        seq = s.encode("hex").upper()
        return " ".join([seq[i:i+2] for i in range(0, len(seq), 2)])

    def findfiles(self, timestamp, tth):
        files = []
        for filename in os.listdir(PCAP_PATH):
            file_ts = filename[6:16]
            delta = abs(int(file_ts) - int(timestamp))
            if delta < (ROTATE_INT+tth):
                files.append(filename)
        return files

    def process_file(self, file, timestamp=None, incident=-1):

        print "Processing file", file, "..."
        path = os.path.join(PCAP_PATH, file)

        if not os.path.exists(path):
            print >>sys.stderr, "[E] File not found or permission denied"
            return -1

        f = open(path)
        pcap = dpkt.pcap.Reader(f)

        for ts, buf in pcap:
            eth = dpkt.ethernet.Ethernet(buf)
            
            if self.tth and abs(float(ts)-float(timestamp)) > self.tth: continue

            """Check if the data is IP packet
            """
            ip = eth.data
            if type(ip) == dpkt.ip.IP:

                pkt = ip.data
                if type(pkt) == dpkt.tcp.TCP:
                    self.db.tcp(incident, psycopg2.TimestampFromTicks(ts),
                        len(buf), self.tohw(eth.src), self.tohw(eth.dst),
                        pkt.sum, pkt.sport, pkt.dport, pkt.seq, pkt.ack, pkt.off_x2,
                        pkt.flags, pkt.win, pkt.urp, ip.v_hl, ip.tos, ip.len, ip.id, ip.off,
                        ip.ttl, ip.p, ip.sum, self.toip(ip.src), self.toip(ip.dst), self.tohex(pkt.data))
                """

                elif type(pkt) == dpkt.udp.UDP:
                    self.db.udp(incident, psycopg2.TimestampFromTicks(ts),
                        len(buf), self.tohw(eth.src), self.tohw(eth.dst),
                        pkt.sum, pkt.sport, pkt.dport, ip.v_hl, ip.tos, ip.len, ip.id, ip.off,
                        ip.ttl, ip.p, ip.sum, self.toip(ip.src), self.toip(ip.dst), self.tohex(pkt.data))

                elif type(pkt) == dpkt.igmp.IGMP:
                    self.db.igmp(incident, psycopg2.TimestampFromTicks(ts),
                        len(buf), self.tohw(eth.src), self.tohw(eth.dst),
                        pkt.sum, pkt.type, pkt.maxresp, pkt.group, ip.v_hl, ip.tos, ip.len, ip.id, ip.off,
                        ip.ttl, ip.p, ip.sum, self.toip(ip.src), self.toip(ip.dst), self.tohex(pkt.data))

                # TODO: elif type(pkt) == dpkt.igmp.IGMP:

                #elif type(pkt) == dkpt.ip.IP:
                #else: print "UNKNOWN PACKET TYPE: %s" % (type(pkt),)
                else: print "[IP PACKET]", "\"%s\"" % (type(pkt),), "not processed"

            elif type(ip) == dpkt.arp.ARP:
                pkt = ip
                self.db.arp(incident, psycopg2.TimestampFromTicks(ts), 
                        len(buf), self.tohw(eth.src), self.tohw(eth.dst),
                        pkt.hrd, pkt.pro, pkt.hln, pkt.pln, pkt.op, self.tohw(pkt.sha), 
                        self.toip(pkt.spa), self.tohw(pkt.tha), self.toip(pkt.tpa))

            else:
                self.db.eth(incident, psycopg2.TimestampFromTicks(ts), 
                        len(buf), self.tohw(eth.src), self.tohw(eth.dst), self.tohex(eth.data))
            """

        f.close()

    def walk(self, timestamp, incident):

        files = self.findfiles(timestamp, self.tth)
        if len(files) == 0:
            print >>sys.stderr, "[E] No files"
            return -1
            
        for file in files:
            self.process_file(file, timestamp, incident)

if __name__ == "__main__":

    parser = argparse.ArgumentParser(description='Parse tcpdump pcap files around timestamp')
    parser.add_argument('--tth', type=int, default=60, help='time threshold')
    parser.add_argument('--file', default=None, help='files to proccess')
    parser.add_argument('--db', default="aips", help='database name')

    args = parser.parse_args()

    #stamp = datetime.datetime.fromtimestamp(args.timestamp)

    if not args.file:
        db = DBWorker(args.db)
        db.connect2DB()
        walker = TCPDumpWalker(db, args.tth)
        db.listen(walker.walk)

    else:
        db = DBWorker(args.db)
        db.connect2DB()
        walker = TCPDumpWalker(db)
        walker.process_file(args.file)
